/*
 * Decompiled with CFR 0.152.
 */
package diss;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import jimena.analysis2.DirectionalValueCentrality;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.SQUADMethod;

public class DirectionalVCSingle {
    public static void main(String[] args) throws Exception {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\realnetworks\\Chondrocyte\\Chondrocyte.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        int simulations = 10000;
        System.out.print("\t");
        String[] stringArray = network.getNodeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.print(String.valueOf(s) + "\t");
            ++n2;
        }
        System.out.println();
        ArrayList<Integer> nodes = new ArrayList<Integer>();
        nodes.add(network.getNodeIndexByName("extPTHrP"));
        nodes.add(network.getNodeIndexByName("extlhh"));
        int outersim = 2000;
        int i = 0;
        while (i < outersim) {
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext()) {
                int node = (Integer)iterator.next();
                String stringNode = network.getNodeNames()[node];
                double[] res = DirectionalValueCentrality.valueCentralityVector(network, node, simulations, parameters);
                System.out.print(String.valueOf(stringNode) + "\t");
                DirectionalVCSingle.printArray(res);
            }
            ++i;
        }
    }

    public static void printArray(double[] values) {
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            System.out.print(String.valueOf(d) + "\t");
            ++n2;
        }
        System.out.println();
    }

    public static double[] significant(double[] array, ArrayList<Integer> significant) {
        double[] result = new double[significant.size()];
        int i = 0;
        while (i < significant.size()) {
            result[i] = array[significant.get(i)];
            ++i;
        }
        return result;
    }

    public static double correlation(double[] p, double[] q) {
        double sumP = 0.0;
        double sumQ = 0.0;
        double sumPSquared = 0.0;
        double sumQSquared = 0.0;
        double sumPQ = 0.0;
        int i = 0;
        while (i < p.length) {
            sumP += p[i];
            sumQ += q[i];
            sumPSquared += p[i] * p[i];
            sumQSquared += q[i] * q[i];
            sumPQ += p[i] * q[i];
            ++i;
        }
        double r = ((double)p.length * sumPQ - sumP * sumQ) / Math.sqrt(((double)p.length * sumPSquared - sumP * sumP) * ((double)p.length * sumQSquared - sumQ * sumQ));
        return r;
    }

    public static void printMatrix(double[][] matrix) {
        System.out.print("{");
        int i = 0;
        while (i < matrix.length) {
            System.out.print("{");
            int j = 0;
            while (j < matrix[0].length) {
                System.out.print(DirectionalVCSingle.math(matrix[i][j]));
                if (j != matrix[0].length - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.print("}");
            if (i != matrix.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
        System.out.println("}");
    }

    public static String math(double input) {
        return String.valueOf(input).replaceAll("E", "\\*^");
    }
}

