/*
 * Decompiled with CFR 0.152.
 */
package diss;

import jimena.analysis.FunctionsAnalysis;
import jimena.analysis.NetworkGenerator;
import jimena.analysis2.Cooperativity;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.SQUADMethod;

public class MatrixDataCollection {
    public static void main(String[] args) throws Exception {
        int simulations = 2000;
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        int reps = 0;
        while (reps < 1000000000) {
            boolean erOrSf = Math.random() < 0.5;
            int size = 15;
            int connections = 25;
            int cycles = 2;
            double act = 0.5;
            boolean inputLoops = true;
            RegulatoryNetwork network = erOrSf ? NetworkGenerator.constructERnetwork(size, connections, cycles, inputLoops, act) : NetworkGenerator.constructSFnetwork(size, connections, cycles, inputLoops, act);
            if (network != null) {
                double[] centralities = new double[network.size()];
                int i = 0;
                while (i < network.size()) {
                    centralities[i] = FunctionsAnalysis.totalCentrality(network, i, simulations, (ConvergenceParameters)parameters);
                    if (Double.isNaN(centralities[i])) {
                        // empty if block
                    }
                    ++i;
                }
                i = 0;
                while (i < network.size()) {
                    int j = 0;
                    while (j < i) {
                        System.out.println(String.valueOf(i) + "\t" + j + "\t" + centralities[i] + "\t" + centralities[j] + "\t" + Cooperativity.totalCentrality(network, simulations, (ConvergenceParameters)parameters, i, j));
                        ++j;
                    }
                    ++i;
                }
            }
            ++reps;
        }
    }
}

