/*
 * Decompiled with CFR 0.152.
 */
package diss;

import java.io.File;
import jimena.analysis.FunctionsAnalysis;
import jimena.analysis2.Cooperativity;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.SQUADMethod;

public class TCCooperativity {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\realnetworks\\Chondrocyte\\Chondrocyte.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        int simulations = 10000;
        double[] vcs = new double[network.size()];
        int i = 0;
        while (i < network.size()) {
            try {
                vcs[i] = FunctionsAnalysis.totalCentrality(network, i, simulations, (ConvergenceParameters)parameters);
                System.out.println(vcs[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < network.size()) {
            int j = 0;
            while (j < i) {
                int extpthrp = network.getNodeIndexByName("extPTHrP");
                if (i == extpthrp || j == extpthrp) {
                    double vcNode1 = 0.0;
                    double vcNode2 = 0.0;
                    double coop = 0.0;
                    try {
                        vcNode1 = vcs[i];
                        vcNode2 = vcs[j];
                        coop = Cooperativity.totalCentrality(network, simulations, (ConvergenceParameters)parameters, i, j);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println(String.valueOf(i) + "\t" + network.getNodeNames()[i] + "\t" + j + "\t" + network.getNodeNames()[j] + "\t" + vcNode1 + "\t" + vcNode2 + "\t" + coop);
                }
                ++j;
            }
            ++i;
        }
    }
}

