/*
 * Decompiled with CFR 0.152.
 */
package diss;

import java.io.File;
import jimena.analysis.FunctionsAnalysis;
import jimena.analysis2.Cooperativity;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.SQUADMethod;

public class TCCooperativityWithAccuracy {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\realnetworks\\Chondrocyte\\Chondrocyte.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        int simulations = 2500;
        double[] vcs = new double[network.size()];
        int i = 0;
        while (i < network.size()) {
            int j = 0;
            while (j < i) {
                int extpthrp = network.getNodeIndexByName("extPTHrP");
                if (i == extpthrp || j == extpthrp) {
                    int k = 0;
                    while (k < 10) {
                        try {
                            double vcNode1 = FunctionsAnalysis.totalCentrality(network, i, simulations, (ConvergenceParameters)parameters);
                            double vcNode2 = FunctionsAnalysis.totalCentrality(network, j, simulations, (ConvergenceParameters)parameters);
                            double coop = Cooperativity.totalCentrality(network, simulations, (ConvergenceParameters)parameters, i, j);
                            double sum = vcNode1 + vcNode2;
                            double ratio = coop / sum;
                            System.out.println(String.valueOf(i) + "\t" + network.getNodeNames()[i] + "\t" + j + "\t" + network.getNodeNames()[j] + "\t" + vcNode1 + "\t" + vcNode2 + "\t" + coop + " \t" + sum + " \t" + ratio);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

