/*
 * Decompiled with CFR 0.152.
 */
package diss;

import jimena.analysis.FunctionsAnalysis;
import jimena.analysis.NetworkGenerator;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.SQUADMethod;

public class VariationOfParameters {
    public static void main(String[] args) {
        try {
            RegulatoryNetwork network = new RegulatoryNetwork();
            int simulations = 1000;
            StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.06);
            double diff = 1.0;
            while (diff <= 1.0) {
                int i = 0;
                while (i < 50) {
                    network = NetworkGenerator.constructSFnetwork(8, 15, 0, true, 0.5);
                    RegulatoryNetwork diffNet = network.cloneClean();
                    NetworkNode[] networkNodeArray = diffNet.getNetworkNodes();
                    int n = networkNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        NetworkNode n3 = networkNodeArray[n2];
                        int j = 0;
                        while (j < n3.getSQUADWeights().length) {
                            n3.getSQUADWeights()[j] = n3.getSQUADWeights()[j] * (1.0 - 0.5 * diff + diff * Math.random());
                            ++j;
                        }
                        ++n2;
                    }
                    int j = 0;
                    while (j < network.size()) {
                        double var = FunctionsAnalysis.totalCentrality(diffNet, j, simulations, (ConvergenceParameters)parameters);
                        double orig = FunctionsAnalysis.totalCentrality(network, j, simulations, (ConvergenceParameters)parameters);
                        System.out.println(String.valueOf(orig) + "\t" + var + "\t" + Math.abs(orig - var) + "\t" + diff);
                        ++j;
                    }
                    ++i;
                }
                diff += 0.05;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

