/*
 * Decompiled with CFR 0.152.
 */
package figures;

import java.io.File;
import jimena.analysis.FunctionsAnalysis;
import jimena.binarybf.actinhibitf.ActivatorInhibitorFunction;
import jimena.binaryrn.NetworkConnection;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.NormalizedHillCubeMethod;

public class FigurePlotInfGraphsAllData {
    public static void main(String[] args) {
        double influence;
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\Controllability\\FigureExplainingSupportingNetworks\\jimena longer output no loop.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new NormalizedHillCubeMethod(), 0.05);
        parameters.setThreads(8);
        int dcOuterSimulations = 1000;
        int dcInnerSimulations = 100;
        System.out.println("== TC of the inputs ==");
        for (NetworkConnection input : network.getConnections()) {
            influence = 0.0;
            try {
                influence = FunctionsAnalysis.totalCentrality(network, input, dcOuterSimulations, (ConvergenceParameters)parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.print(",{" + network.getConnectionString(input) + "," + FigurePlotInfGraphsAllData.math(influence) + "}");
        }
        System.out.println("\n\n== VC of the inputs ==");
        for (NetworkConnection input : network.getConnections()) {
            influence = 0.0;
            try {
                influence = FunctionsAnalysis.valueCentrality(network, input, dcOuterSimulations, (ConvergenceParameters)parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.print(",{" + network.getConnectionString(input) + "," + FigurePlotInfGraphsAllData.math(influence) + "}");
        }
        System.out.println("\n\n== DC of the inputs ==");
        for (NetworkConnection input : network.getConnections()) {
            influence = 0.0;
            try {
                influence = FunctionsAnalysis.dynamicCentrality(network, input, dcOuterSimulations, dcInnerSimulations, (ConvergenceParameters)parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.print(",{" + network.getConnectionString(input) + "," + FigurePlotInfGraphsAllData.math(influence) + "}");
        }
        System.out.println("\n\n== TC of the nodes ==");
        double[][] matrixTC = null;
        try {
            matrixTC = FunctionsAnalysis.totalCentralityMatrix(network, dcOuterSimulations, parameters);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        double[] tcCentralities = FunctionsAnalysis.centralitiesFromMatrix(matrixTC);
        int i = 0;
        while (i < network.getNetworkNodes().length) {
            System.out.print(", \"" + network.getNodeNames()[i] + "\", " + FigurePlotInfGraphsAllData.math(tcCentralities[i]));
            ++i;
        }
        System.out.println("\n\n== TC-sensitivities of the nodes ==");
        double[] tcSensitivities = FunctionsAnalysis.sensitivitiesFromMatrix(matrixTC);
        int i2 = 0;
        while (i2 < network.getNetworkNodes().length) {
            System.out.print(", \"" + network.getNodeNames()[i2] + "\", " + FigurePlotInfGraphsAllData.math(tcSensitivities[i2]));
            ++i2;
        }
        System.out.println("\n\n== VC of the nodes ==");
        double[][] matrixVC = null;
        try {
            matrixVC = FunctionsAnalysis.valueCentralityMatrix(network, dcOuterSimulations, parameters);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        double[] vcCentralities = FunctionsAnalysis.centralitiesFromMatrix(matrixVC);
        int i3 = 0;
        while (i3 < network.getNetworkNodes().length) {
            System.out.print(", \"" + network.getNodeNames()[i3] + "\", " + FigurePlotInfGraphsAllData.math(vcCentralities[i3]));
            ++i3;
        }
        System.out.println("\n\n== VC-sensitivities of the nodes ==");
        double[] vcSensitivities = FunctionsAnalysis.sensitivitiesFromMatrix(matrixVC);
        int i4 = 0;
        while (i4 < network.getNetworkNodes().length) {
            System.out.print(", \"" + network.getNodeNames()[i4] + "\", " + FigurePlotInfGraphsAllData.math(vcSensitivities[i4]));
            ++i4;
        }
        System.out.println("\n\n== DC of the nodes ==");
        double[] dcCentralities = null;
        try {
            dcCentralities = FunctionsAnalysis.dynamicCentralities(network, dcOuterSimulations, dcInnerSimulations, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i5 = 0;
        while (i5 < network.getNetworkNodes().length) {
            System.out.print(", \"" + network.getNodeNames()[i5] + "\", " + FigurePlotInfGraphsAllData.math(dcCentralities[i5]));
            ++i5;
        }
        System.out.println("\n\n== Positions ==");
        double SCALE = 120.0;
        int i6 = 0;
        while (i6 < network.getNetworkNodes().length) {
            NetworkNode node = network.getNetworkNodes()[i6];
            System.out.print(", \"" + network.getNodeNames()[i6] + "\" -> {" + FigurePlotInfGraphsAllData.math(node.getRectangle().getX() / 120.0) + ", " + FigurePlotInfGraphsAllData.math(node.getRectangle().getY() / 120.0) + "}");
            ++i6;
        }
        System.out.println("\n\n== Inhibiting ==");
        for (NetworkConnection input : network.getConnections()) {
            if (((ActivatorInhibitorFunction)network.getNetworkNodes()[input.getNode()].getFunction()).getActivators()[input.getPosition()]) continue;
            System.out.print(", {" + network.getConnectionString(input, ", ") + "}");
        }
        System.out.println("\n\n== Table ==");
        System.out.println("nodes name\ttc\tvc\tdc\ttc-sensitivity\tvc-sensitivity\toutgoing\tincoming\tloop");
        i = 0;
        while (i < network.getNetworkNodes().length) {
            System.out.println(String.valueOf(network.getNodeNames()[i]) + "\t" + tcCentralities[i] + "\t" + vcCentralities[i] + "\t" + dcCentralities[i] + "\t" + tcSensitivities[i] + "\t" + vcSensitivities[i] + "\t" + network.getConnectionsBySource(i).size() + "\t" + network.getConnectionsByTarget(i).size() + "\t" + network.hasLoop(i));
            ++i;
        }
    }

    public static String math(double input) {
        return String.valueOf(input).replaceAll("E", "\\*^");
    }
}

