/*
 * Decompiled with CFR 0.152.
 */
package genomewide;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import jimena.analysis.FunctionsAnalysis;
import jimena.analysis.NetworkGenerator;
import jimena.analysis.Statistics;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.libs.MathLib;
import jimena.simulationmethods.SQUADMethod;

public class ImportPseudomonas {
    public static RegulatoryNetwork pseudomonasNetwork() {
        RegulatoryNetwork network = null;
        try {
            String line;
            ArrayList<String> nodes = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(new File("K:\\GenomeWideNets\\Pseudomonas\\bereinigt.txt")));
            while ((line = br.readLine()) != null) {
                String[] lineArray = line.split("\\t");
                String influencing = lineArray[0].toLowerCase();
                if (nodes.contains(influencing)) continue;
                nodes.add(influencing);
            }
            ArrayList<Integer> from = new ArrayList<Integer>();
            ArrayList<Integer> to = new ArrayList<Integer>();
            ArrayList<Boolean> activating = new ArrayList<Boolean>();
            br = new BufferedReader(new FileReader(new File("K:\\GenomeWideNets\\Pseudomonas\\bereinigt.txt")));
            while ((line = br.readLine()) != null) {
                String influencing;
                String influenced;
                String[] lineArray = line.split("\\t");
                if (lineArray[2].equals("+")) {
                    influenced = lineArray[1].toLowerCase();
                    influencing = lineArray[0].toLowerCase();
                    if (nodes.indexOf(influenced) == -1) continue;
                    to.add(nodes.indexOf(influenced));
                    from.add(nodes.indexOf(influencing));
                    activating.add(true);
                }
                if (!lineArray[2].equals("-")) continue;
                influenced = lineArray[1].toLowerCase();
                influencing = lineArray[0].toLowerCase();
                if (nodes.indexOf(influenced) == -1) continue;
                to.add(nodes.indexOf(influenced));
                from.add(nodes.indexOf(influencing));
                activating.add(false);
            }
            NetworkGenerator.addInputLoops(from, to, activating, nodes.size());
            network = NetworkGenerator.constructNetwork(from, to, activating, nodes.size());
            network.setNames(nodes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return network;
    }

    public static void main(String[] args) {
        RegulatoryNetwork network = ImportPseudomonas.pseudomonasNetwork();
        System.out.println(network.size());
        System.out.println(network.getConnections().size());
        int simulations = 1;
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        double[][] matrixTC = null;
        try {
            matrixTC = FunctionsAnalysis.totalCentralityMatrix(network, simulations, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double[][] matrixNDC = null;
        try {
            matrixNDC = FunctionsAnalysis.valueCentralityMatrix(network, simulations, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double meanNDC = MathLib.average(FunctionsAnalysis.centralitiesFromMatrix(matrixNDC));
        double meanTC = MathLib.average(FunctionsAnalysis.centralitiesFromMatrix(matrixTC));
        System.out.print("\n");
        System.out.print(String.valueOf(meanNDC) + "\t");
        System.out.print(String.valueOf(meanTC) + "\t");
        System.out.print(String.valueOf(meanNDC / meanTC) + "\t");
        System.out.print(String.valueOf(Statistics.gini(FunctionsAnalysis.centralitiesFromMatrix(matrixTC))) + "\t");
        System.out.print(String.valueOf(Statistics.gini(FunctionsAnalysis.sensitivitiesFromMatrix(matrixTC))) + "\t");
        System.out.print(String.valueOf(Statistics.gini(FunctionsAnalysis.centralitiesFromMatrix(matrixNDC))) + "\t");
        System.out.print(String.valueOf(Statistics.gini(FunctionsAnalysis.sensitivitiesFromMatrix(matrixNDC))) + "\t");
        System.out.print(String.valueOf(MathLib.dotProductUnchecked(FunctionsAnalysis.centralitiesFromMatrix(matrixNDC), FunctionsAnalysis.sensitivitiesFromMatrix(matrixNDC))) + "\t");
        System.out.print(MathLib.dotProductUnchecked(FunctionsAnalysis.centralitiesFromMatrix(matrixTC), FunctionsAnalysis.sensitivitiesFromMatrix(matrixTC)));
        System.out.print("\n");
        System.out.print("\n");
        System.out.print("\n");
        int i = 0;
        while (i < network.size()) {
            double[] ndcCentralities = FunctionsAnalysis.centralitiesFromMatrix(matrixNDC);
            double[] tcCentralities = FunctionsAnalysis.centralitiesFromMatrix(matrixTC);
            double[] ndcSensitivities = FunctionsAnalysis.sensitivitiesFromMatrix(matrixNDC);
            double[] tcSensitivities = FunctionsAnalysis.sensitivitiesFromMatrix(matrixTC);
            System.out.print(String.valueOf(network.getNodeNames()[i]) + "\t");
            System.out.print(String.valueOf(ndcCentralities[i]) + "\t");
            try {
                System.out.print(String.valueOf(FunctionsAnalysis.dynamicCentrality(network, i, 15, 15, (ConvergenceParameters)parameters)) + "\t");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.print(String.valueOf(tcCentralities[i]) + "\t");
            System.out.print(String.valueOf(ndcSensitivities[i]) + "\t");
            System.out.print(String.valueOf(tcSensitivities[i]) + "\t");
            System.out.print(String.valueOf(network.cycleIndex(i, true)) + "\t");
            System.out.print(String.valueOf(network.cycleIndex(i, false)) + "\t");
            System.out.print(String.valueOf(network.getConnectionsBySource(i).size()) + "\t");
            System.out.print(String.valueOf(network.getConnectionsByTarget(i).size()) + "\t");
            System.out.print(String.valueOf(network.hasLoop(i)) + "\t");
            System.out.print("\n");
            ++i;
        }
    }
}

