/*
 * Decompiled with CFR 0.152.
 */
package jimena.analysis;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jimena.analysis.ConvergenceComparator;
import jimena.binaryrn.Connection;
import jimena.binaryrn.NetworkConnection;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.gui.main.JimenaExecutor;
import jimena.libs.ArrayLib;
import jimena.libs.BooleanValue;
import jimena.libs.MathLib;
import jimena.simulation.CalculationController;
import jimena.simulation.ConvergenceResult;
import jimena.simulation.StableSteadyState;

public class FunctionsAnalysis {
    private static void abortAll(ArrayList<Future<Double>> runs) {
        for (Future<Double> run : runs) {
            run.cancel(true);
        }
    }

    public static double[] centralitiesFromMatrix(double[][] matrix) {
        if (matrix == null) {
            return null;
        }
        return FunctionsAnalysis.centralitiesFromMatrix(matrix, MathLib.numberSet(matrix.length - 1));
    }

    public static double[] centralitiesFromMatrix(double[][] matrix, Set<Integer> nodesToConsider) {
        if (matrix == null) {
            return null;
        }
        double[] result = new double[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            result[i] = FunctionsAnalysis.centralityFromMatrix(matrix, i, nodesToConsider);
            ++i;
        }
        return result;
    }

    public static double centralityFromMatrix(double[][] matrix, int node) {
        return FunctionsAnalysis.centralityFromMatrix(matrix, node, MathLib.numberSet(matrix.length - 1));
    }

    public static double centralityFromMatrix(double[][] matrix, int node, Set<Integer> nodesToConsider) {
        if (matrix == null) {
            return Double.NaN;
        }
        double result = 0.0;
        int counter = 0;
        for (Integer i : nodesToConsider) {
            result += matrix[node][i];
            ++counter;
        }
        return result / (double)counter;
    }

    public static double[] dynamicCentralities(RegulatoryNetwork network, int simulations, int innersimulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.dynamicCentralities(network, simulations, innersimulations, parameters, network.setOfAllNodeIndices());
    }

    public static double[] dynamicCentralities(RegulatoryNetwork network, int simulations, int innersimulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider) throws Exception {
        double[] influences = new double[network.size()];
        int i = 0;
        while (i < network.size()) {
            influences[i] = FunctionsAnalysis.dynamicCentrality(network, i, simulations, innersimulations, parameters.cloneWithoutController(), nodesToConsider);
            if (parameters.getCalculationController() != null && !parameters.getCalculationController().isOn()) {
                return null;
            }
            if (parameters.getCalculationController() != null) {
                parameters.getCalculationController().setProgress(i + 1, network.size());
            }
            ++i;
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return influences;
    }

    public static double dynamicCentrality(RegulatoryNetwork network, int node, int simulations, int innersimulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.dynamicCentrality(network, node, simulations, innersimulations, parameters, network.setOfAllNodeIndices());
    }

    public static double dynamicCentrality(RegulatoryNetwork network, int node, int simulations, int innersimulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider) throws Exception {
        return FunctionsAnalysis.dynamicCentrality(network, node, simulations, innersimulations, parameters, nodesToConsider, new TreeSet<Integer>());
    }

    public static double dynamicCentrality(RegulatoryNetwork network, int node, int simulations, int innersimulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider, Set<Integer> protectedNodes) throws Exception {
        return FunctionsAnalysis.dynamicCentrality(network, node, simulations, innersimulations, parameters, nodesToConsider, protectedNodes, Double.MAX_VALUE);
    }

    public static double dynamicCentrality(RegulatoryNetwork network, int node, int simulations, int innersimulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider, Set<Integer> protectedNodes, double threshold) throws Exception {
        JimenaExecutor threadPool = new JimenaExecutor(parameters.getThreads());
        ArrayList<Future<Double>> searchers = new ArrayList<Future<Double>>();
        FunctionsAnalysis enclosing = new FunctionsAnalysis();
        int i = 0;
        while (i < simulations) {
            FunctionsAnalysis functionsAnalysis = enclosing;
            functionsAnalysis.getClass();
            searchers.add(threadPool.submit(functionsAnalysis.new MinInfluence(network, node, parameters.cloneWithoutController(), nodesToConsider, innersimulations, protectedNodes)));
            ++i;
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            double minResult = FunctionsAnalysis.minResult(searchers);
            if (minResult > threshold && !Double.isInfinite(minResult)) {
                FunctionsAnalysis.abortAll(searchers);
                try {
                    threadPool.awaitTermination(240L, TimeUnit.HOURS);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                return minResult;
            }
            if (parameters.getCalculationController() != null && !parameters.getCalculationController().isOn()) {
                return Double.NaN;
            }
            FunctionsAnalysis.setCalculationController(searchers, parameters.getCalculationController());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            threadPool.awaitTermination(240L, TimeUnit.HOURS);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        double sumOfDifference = 0.0;
        int counted = 0;
        int i2 = 0;
        while (i2 < simulations) {
            if (!Double.isNaN(searchers.get(i2).get())) {
                sumOfDifference += searchers.get(i2).get().doubleValue();
                ++counted;
            }
            ++i2;
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return sumOfDifference / (double)counted;
    }

    public static double dynamicCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, int innersimulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.dynamicCentrality(network, connection, simulations, innersimulations, parameters, network.setOfAllNodeIndices());
    }

    public static double dynamicCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, int innersimulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider) throws Exception {
        return FunctionsAnalysis.dynamicCentrality(network, connection, simulations, innersimulations, parameters, nodesToConsider, new TreeSet<Integer>());
    }

    public static double dynamicCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, int innersimulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider, Set<Integer> protectedNodes) throws Exception {
        return FunctionsAnalysis.dynamicCentrality(network, connection, simulations, innersimulations, parameters, nodesToConsider, protectedNodes, Double.MAX_VALUE);
    }

    public static double dynamicCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, int innersimulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider, Set<Integer> protectedNodes, double threshold) throws Exception {
        JimenaExecutor threadPool = new JimenaExecutor(parameters.getThreads());
        ArrayList<Future<Double>> runs = new ArrayList<Future<Double>>();
        FunctionsAnalysis enclosing = new FunctionsAnalysis();
        int i = 0;
        while (i < simulations) {
            FunctionsAnalysis functionsAnalysis = enclosing;
            functionsAnalysis.getClass();
            runs.add(threadPool.submit(functionsAnalysis.new MinInfluence(network, connection, parameters.cloneWithoutController(), nodesToConsider, innersimulations, protectedNodes)));
            ++i;
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            double minResult = FunctionsAnalysis.minResult(runs);
            if (minResult > threshold && !Double.isInfinite(minResult)) {
                FunctionsAnalysis.abortAll(runs);
                try {
                    threadPool.awaitTermination(240L, TimeUnit.HOURS);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                return minResult;
            }
            if (parameters.getCalculationController() != null && !parameters.getCalculationController().isOn()) {
                return Double.NaN;
            }
            FunctionsAnalysis.setCalculationController(runs, parameters.getCalculationController());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            threadPool.awaitTermination(240L, TimeUnit.HOURS);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        double sumOfDifference = 0.0;
        int counted = 0;
        int i2 = 0;
        while (i2 < simulations) {
            if (runs.get(i2).get() != null && !Double.isNaN(runs.get(i2).get()) && !Double.isInfinite(runs.get(i2).get())) {
                sumOfDifference += runs.get(i2).get().doubleValue();
                ++counted;
            }
            ++i2;
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return sumOfDifference / (double)counted;
    }

    static boolean isValid(double[] values) {
        if (values == null) {
            return false;
        }
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String mathNumberFormat(double value) {
        return String.valueOf(value).replaceAll("E", "\\*^");
    }

    private static double minInfluence(RegulatoryNetwork network, int node, double[] initialVector, int simulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider, Set<Integer> protectedNodes) throws Exception {
        RegulatoryNetwork network1 = network.cloneClean();
        RegulatoryNetwork network2 = network.cloneClean();
        for (NetworkConnection connection : network.getConnectionsBySource(node)) {
            FunctionsAnalysis.splitConnection(network1, connection);
            FunctionsAnalysis.splitConnection(network2, connection);
            network1.addNullMutation(connection);
        }
        double minInfluence = Double.NaN;
        int i = 0;
        while (i < simulations) {
            double[] initVector = (double[])initialVector.clone();
            for (NetworkConnection connection : network.getConnectionsBySource(node)) {
                initVector = !protectedNodes.contains(node) ? ArrayLib.add(initVector, Math.random()) : ArrayLib.add(initVector, initVector[node]);
            }
            network1.setValues(initVector);
            network2.setValues(initVector);
            StableSteadyState n1 = new StableSteadyState(network1, parameters);
            StableSteadyState n2 = new StableSteadyState(network2, parameters);
            if (n1.call() != null && n2.call() != null) {
                double diff = MathLib.meanSquaredDifferenceUnchecked(n1.call().getResult(), n2.call().getResult(), nodesToConsider);
                minInfluence = MathLib.min(minInfluence, diff);
            }
            if (protectedNodes.contains(node) && minInfluence != Double.MAX_VALUE || minInfluence < 1.0E-15) break;
            ++i;
        }
        return minInfluence;
    }

    private static double minInfluence(RegulatoryNetwork network, NetworkConnection connection, double[] initialVector, int simulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider, Set<Integer> protectedNodes) throws Exception {
        int source = network.getConnection(connection).getSource();
        RegulatoryNetwork network1 = network.cloneClean();
        RegulatoryNetwork network2 = network.cloneClean();
        FunctionsAnalysis.splitConnection(network1, connection);
        FunctionsAnalysis.splitConnection(network2, connection);
        network1.addNullMutation(connection);
        double minInfluence = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < simulations) {
            double[] initVector = (double[])initialVector.clone();
            initVector = !protectedNodes.contains(source) ? ArrayLib.add(initVector, Math.random()) : ArrayLib.add(initVector, initVector[source]);
            network1.setValues(initVector);
            network2.setValues(initVector);
            StableSteadyState n1 = new StableSteadyState(network1, parameters);
            StableSteadyState n2 = new StableSteadyState(network2, parameters);
            if (n1.call() != null && n2.call() != null) {
                double diff = MathLib.meanSquaredDifferenceUnchecked(n1.call().getResult(), n2.call().getResult(), nodesToConsider);
                minInfluence = MathLib.min(minInfluence, diff);
            }
            if (protectedNodes.contains(source) && minInfluence != Double.MAX_VALUE || minInfluence < 1.0E-15) break;
            ++i;
        }
        return minInfluence;
    }

    private static double minResult(ArrayList<Future<Double>> runs) throws Exception {
        double sumOfDifference = 0.0;
        int i = 0;
        while (i < runs.size()) {
            if (runs.get(i).isDone()) {
                sumOfDifference += runs.get(i).get().doubleValue();
            }
            ++i;
        }
        return sumOfDifference / (double)runs.size();
    }

    public static double[] sensitivitiesFromMatrix(double[][] matrix) {
        if (matrix == null) {
            return null;
        }
        double[] result = new double[matrix.length];
        int i = 0;
        while (i < matrix.length) {
            result[i] = FunctionsAnalysis.sensitivityFromMatrix(matrix, i);
            ++i;
        }
        return result;
    }

    public static double sensitivityFromMatrix(double[][] matrix, int node) {
        if (matrix == null) {
            return Double.NaN;
        }
        double result = 0.0;
        int i = 0;
        while (i < matrix.length) {
            result += matrix[i][node];
            ++i;
        }
        return result / (double)matrix.length;
    }

    static void setCalculationController(ArrayList<Future<ConvergenceResult>> searchers1, ArrayList<Future<ConvergenceResult>> searchers2, CalculationController controller) {
        int sum = 0;
        int done = 0;
        for (Future<ConvergenceResult> run : searchers1) {
            ++sum;
            if (!run.isDone()) continue;
            ++done;
        }
        for (Future<ConvergenceResult> run : searchers2) {
            ++sum;
            if (!run.isDone()) continue;
            ++done;
        }
        if (controller != null) {
            controller.setProgress(done, sum);
        }
    }

    private static void setCalculationController(ArrayList<Future<Double>> searchers, CalculationController controller) {
        int sum = 0;
        int done = 0;
        for (Future<Double> run : searchers) {
            ++sum;
            if (!run.isDone()) continue;
            ++done;
        }
        if (controller != null) {
            controller.setProgress(done, sum);
        }
    }

    static void splitConnection(RegulatoryNetwork network, NetworkConnection connection) {
        int source = network.getConnection(connection).getSource();
        network.setNetworkNodes(ArrayLib.add(network.getNetworkNodes(), network.getNetworkNodes()[source].clone()));
        network.getConnection(connection).setSource(network.size() - 1);
        Connection[] connectionArray = network.getNetworkNodes()[network.size() - 1].getConnections();
        int n = connectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connection i = connectionArray[n2];
            if (i.getSource() == source) {
                i.setSource(network.size() - 1);
            }
            ++n2;
        }
    }

    public static double[] totalCentralities(RegulatoryNetwork network, int simulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.centralitiesFromMatrix(FunctionsAnalysis.totalCentralityMatrix(network, simulations, parameters));
    }

    public static double totalCentrality(RegulatoryNetwork network, int simulations, ConvergenceParameters parameters) throws Exception {
        double sum = 0.0;
        int i = 0;
        while (i < network.size()) {
            if (Double.isNaN(sum += FunctionsAnalysis.totalCentrality(network, i, simulations, parameters))) break;
            if (parameters.getCalculationController() != null && !parameters.getCalculationController().isOn()) {
                return Double.NaN;
            }
            if (parameters.getCalculationController() != null) {
                parameters.getCalculationController().setProgress(i + 1, network.size());
            }
            ++i;
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return sum / (double)network.size();
    }

    public static double totalCentrality(RegulatoryNetwork network, int node, int simulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.totalCentrality(network, node, simulations, parameters, network.setOfAllNodeIndices());
    }

    public static double totalCentrality(RegulatoryNetwork network, int node, int simulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider) throws Exception {
        ArrayList<NetworkConnection> connections = network.getConnectionsBySource(node);
        RegulatoryNetwork mutated = network.cloneClean();
        mutated.addNullMutation(connections);
        return ConvergenceComparator.difference(network, mutated, simulations, parameters);
    }

    public static double totalCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.totalCentrality(network, connection, simulations, parameters, network.setOfAllNodeIndices());
    }

    public static double totalCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider) throws Exception {
        RegulatoryNetwork mutated = network.cloneClean();
        mutated.addNullMutation(connection);
        return ConvergenceComparator.difference(network, mutated, simulations, parameters);
    }

    public static double[][] totalCentralityMatrix(RegulatoryNetwork network, int simulations, ConvergenceParameters parameters) throws Exception {
        double[][] matrix = new double[network.size()][];
        int i = 0;
        while (i < network.size()) {
            matrix[i] = FunctionsAnalysis.totalCentralityVector(network, i, simulations, parameters.cloneWithoutController());
            while (!FunctionsAnalysis.isValid(matrix[i])) {
                matrix[i] = FunctionsAnalysis.totalCentralityVector(network, i, simulations, parameters.cloneWithoutController());
            }
            if (parameters.getCalculationController() != null && !parameters.getCalculationController().isOn()) {
                return null;
            }
            if (parameters.getCalculationController() != null) {
                parameters.getCalculationController().setProgress(i + 1, network.size());
            }
            ++i;
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return matrix;
    }

    public static double[] totalCentralityVector(RegulatoryNetwork network, int node, int simulations, ConvergenceParameters parameters) throws Exception {
        ArrayList<NetworkConnection> connections = network.getConnectionsBySource(node);
        RegulatoryNetwork mutated = network.cloneClean();
        mutated.addNullMutation(connections);
        return ConvergenceComparator.differenceV(network, mutated, simulations, parameters);
    }

    public static double[] valueCentralities(RegulatoryNetwork network, int simulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.centralitiesFromMatrix(FunctionsAnalysis.valueCentralityMatrix(network, simulations, parameters));
    }

    public static double valueCentrality(RegulatoryNetwork network, int simulations, ConvergenceParameters parameters) throws Exception {
        double sum = 0.0;
        int i = 0;
        while (i < network.size()) {
            sum += FunctionsAnalysis.valueCentrality(network, i, simulations, parameters.cloneWithoutController());
            if (parameters.getCalculationController() != null && !parameters.getCalculationController().isOn()) {
                return Double.NaN;
            }
            if (parameters.getCalculationController() != null) {
                parameters.getCalculationController().setProgress(i + 1, network.size());
            }
            ++i;
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return sum / (double)network.size();
    }

    public static double valueCentrality(RegulatoryNetwork network, int node, int simulations, ConvergenceParameters parameters) throws Exception {
        return FunctionsAnalysis.valueCentrality(network, node, simulations, parameters, network.setOfAllNodeIndices());
    }

    public static double valueCentrality(RegulatoryNetwork network, int node, int simulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider) throws Exception {
        double[] temp = FunctionsAnalysis.valueCentralityVector(network, node, simulations, parameters);
        double result = 0.0;
        int counter = 0;
        for (Integer i : nodesToConsider) {
            result += temp[i];
            ++counter;
        }
        return result / (double)counter;
    }

    public static double valueCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, ConvergenceParameters parameters) throws Exception {
        return MathLib.average(FunctionsAnalysis.valueCentralityVector(network, connection, simulations, parameters));
    }

    public static double valueCentrality(RegulatoryNetwork network, NetworkConnection connection, int simulations, ConvergenceParameters parameters, Set<Integer> nodesToConsider) throws Exception {
        return MathLib.average(FunctionsAnalysis.valueCentralityVector(network, connection, simulations, parameters), nodesToConsider);
    }

    public static double[][] valueCentralityMatrix(RegulatoryNetwork network, int simulations, ConvergenceParameters parameters) throws Exception {
        double[][] matrix = new double[network.size()][];
        int i = 0;
        while (i < network.size()) {
            matrix[i] = FunctionsAnalysis.valueCentralityVector(network, i, simulations, parameters.cloneWithoutController());
            while (!FunctionsAnalysis.isValid(matrix[i])) {
                matrix[i] = FunctionsAnalysis.valueCentralityVector(network, i, simulations, parameters.cloneWithoutController());
            }
            if (parameters.getCalculationController() != null && !parameters.getCalculationController().isOn()) {
                return null;
            }
            if (parameters.getCalculationController() != null) {
                parameters.getCalculationController().setProgress(i + 1, network.size());
            }
            ++i;
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return matrix;
    }

    public static double[] valueCentralityVector(RegulatoryNetwork network, int node, int simulations, ConvergenceParameters parameters) throws Exception {
        JimenaExecutor threadPool = new JimenaExecutor(parameters.getThreads());
        ArrayList<Future<ConvergenceResult>> searchers1 = new ArrayList<Future<ConvergenceResult>>();
        ArrayList<Future<ConvergenceResult>> searchers2 = new ArrayList<Future<ConvergenceResult>>();
        int i = 0;
        while (i < simulations) {
            double[] startValues1 = MathLib.randomVector(network.size());
            double[] startValues2 = (double[])startValues1.clone();
            startValues2[node] = Math.random();
            RegulatoryNetwork networkN1 = network.cloneClean();
            RegulatoryNetwork networkN2 = network.cloneClean();
            networkN1.setValues(startValues1);
            networkN2.setValues(startValues2);
            searchers1.add(threadPool.submit(new StableSteadyState(networkN1, parameters.cloneWithoutController())));
            searchers2.add(threadPool.submit(new StableSteadyState(networkN2, parameters.cloneWithoutController())));
            ++i;
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            block8: {
                Thread.sleep(500L);
                if (parameters.getCalculationController() == null || parameters.getCalculationController().isOn()) break block8;
                return null;
            }
            try {
                FunctionsAnalysis.setCalculationController(searchers1, searchers2, parameters.getCalculationController());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        double[] sumOfDifference = new double[network.size()];
        int counted = 0;
        int i2 = 0;
        while (i2 < simulations) {
            if (searchers1.get(i2).get() != null && searchers2.get(i2).get() != null) {
                MathLib.addDoubleArraysUnchecked(sumOfDifference, MathLib.squaredDifferenceUnchecked(searchers1.get(i2).get().getResult(), searchers2.get(i2).get().getResult()));
                ++counted;
            }
            ++i2;
        }
        MathLib.scaleUnchecked(sumOfDifference, 1.0 / (double)counted);
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return sumOfDifference;
    }

    public static double[] valueCentralityVector(RegulatoryNetwork network, NetworkConnection connection, int simulations, ConvergenceParameters parameters) throws Exception {
        int source = network.getConnection(connection).getSource();
        JimenaExecutor threadPool = new JimenaExecutor(parameters.getThreads());
        ArrayList<Future<ConvergenceResult>> searchers1 = new ArrayList<Future<ConvergenceResult>>();
        ArrayList<Future<ConvergenceResult>> searchers2 = new ArrayList<Future<ConvergenceResult>>();
        int i = 0;
        while (i < simulations) {
            double[] startValues1 = MathLib.randomVector(network.size());
            double[] startValues2 = (double[])startValues1.clone();
            startValues1 = ArrayLib.add(startValues1, startValues1[source]);
            startValues2 = ArrayLib.add(startValues2, Math.random());
            RegulatoryNetwork networkN1 = network.cloneClean();
            RegulatoryNetwork networkN2 = network.cloneClean();
            FunctionsAnalysis.splitConnection(networkN1, connection);
            FunctionsAnalysis.splitConnection(networkN2, connection);
            networkN1.setValues(startValues1);
            networkN2.setValues(startValues2);
            searchers1.add(threadPool.submit(new StableSteadyState(networkN1, parameters.cloneWithoutController())));
            searchers2.add(threadPool.submit(new StableSteadyState(networkN2, parameters.cloneWithoutController())));
            ++i;
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            block8: {
                Thread.sleep(500L);
                if (parameters.getCalculationController() == null || parameters.getCalculationController().isOn()) break block8;
                return null;
            }
            try {
                FunctionsAnalysis.setCalculationController(searchers1, searchers2, parameters.getCalculationController());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        double[] sumOfDifference = new double[network.size()];
        int counted = 0;
        int i2 = 0;
        while (i2 < simulations) {
            if (searchers1.get(i2).get() != null && searchers2.get(i2).get() != null) {
                MathLib.addDoubleArraysUnchecked(sumOfDifference, MathLib.squaredDifferenceUnchecked(searchers1.get(i2).get().getResult(), searchers2.get(i2).get().getResult()));
                ++counted;
            }
            ++i2;
        }
        MathLib.scaleUnchecked(sumOfDifference, 1.0 / (double)counted);
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return sumOfDifference;
    }

    private class MinInfluence
    implements Callable<Double> {
        private RegulatoryNetwork network;
        private NetworkConnection connection = null;
        private int node = -1;
        private Set<Integer> nodesToConsider;
        private Set<Integer> protectedNodes;
        private ConvergenceParameters parameters;
        private int simulations;
        private BooleanValue aborted = new BooleanValue(false);

        public MinInfluence(RegulatoryNetwork network, int node, ConvergenceParameters parameters, Set<Integer> nodesToConsider, int simulations, Set<Integer> protectedNodes) {
            this.network = network;
            this.node = node;
            this.nodesToConsider = nodesToConsider;
            this.parameters = parameters;
            this.simulations = simulations;
            this.protectedNodes = protectedNodes;
        }

        public MinInfluence(RegulatoryNetwork network, NetworkConnection connection, ConvergenceParameters parameters, Set<Integer> nodesToConsider, int simulations, Set<Integer> protectedNodes) {
            this.network = network;
            this.connection = connection;
            this.nodesToConsider = nodesToConsider;
            this.parameters = parameters;
            this.simulations = simulations;
            this.protectedNodes = protectedNodes;
        }

        @Override
        public Double call() throws Exception {
            if (this.aborted.getValue()) {
                return Double.NaN;
            }
            double[] initialVector = MathLib.randomVector(this.network.size());
            if (this.connection != null) {
                return FunctionsAnalysis.minInfluence(this.network, this.connection, initialVector, this.simulations, this.parameters, (Set<Integer>)this.nodesToConsider, (Set<Integer>)this.protectedNodes);
            }
            return FunctionsAnalysis.minInfluence(this.network, this.node, initialVector, this.simulations, this.parameters, (Set<Integer>)this.nodesToConsider, (Set<Integer>)this.protectedNodes);
        }
    }
}

