/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.guilib.datatable;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.ImageIcon;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.gui.guilib.datatable.TableJFrame;
import jimena.gui.guilib.datatable.TableModelNodes;
import jimena.gui.main.HasActivatableNodes;
import jimena.libs.StringLib;

public class NodesTable
extends TableJFrame
implements HasActivatableNodes {
    private static final long serialVersionUID = 7948800228008893672L;

    public NodesTable(final RegulatoryNetwork network) {
        super(new TableModelNodes(network), "Nodes Table - Ctrl+V: load state from clipboard", new ImageIcon("images" + File.separator + "table16.png").getImage());
        KeyListener[] keyListenerArray = this.getKeyListeners();
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener listener = keyListenerArray[n2];
            this.getTable().removeKeyListener(listener);
            ++n2;
        }
        this.getTable().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 86 && e.isControlDown()) {
                    String[] possibleSeparators;
                    String clipboard = StringLib.readFromClipboard();
                    String[] stringArray = possibleSeparators = new String[]{"\t", System.getProperty("line.separator"), "\n"};
                    int n = possibleSeparators.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String separator = stringArray[n2];
                        if (clipboard.contains(separator)) {
                            String[] stringValues = clipboard.split(separator);
                            double[] values = new double[network.size()];
                            int i = 0;
                            while (i < Math.min(values.length, stringValues.length)) {
                                try {
                                    values[i] = Double.valueOf(stringValues[i]);
                                }
                                catch (NumberFormatException ex) {
                                    return;
                                }
                                ++i;
                            }
                            network.setValues(values);
                            network.notifyObserversOfChangedValues();
                            return;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    @Override
    public void activateNode(int nodeIndex) {
        this.setVisible(true);
        this.getTable().changeSelection(nodeIndex, 1, false, false);
    }
}

