/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.guilib.datatable;

import java.util.TreeMap;
import jimena.binaryrn.Connection;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.gui.guilib.datatable.NetworkTableModel;

public class TableModelConnections
extends NetworkTableModel
implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = 8255195334564743582L;
    private TreeMap<Integer, Integer> mapRowToNode;
    private TreeMap<Integer, Integer> mapRowToConnection;

    public TableModelConnections(RegulatoryNetwork network) {
        super(network);
    }

    @Override
    public String getColumnName(int col) {
        String[] columns = new String[]{"Node", "Input", "Hill k", "Hill n", "SQUAD weight"};
        return columns[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        Class[] columnClasses = new Class[]{String.class, String.class, Double.class, Double.class, Double.class};
        return columnClasses[col];
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.mapRowToNode.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.mapRowToConnection.containsKey(row)) {
            int nodeIndex = this.mapRowToNode.get(row);
            switch (col) {
                case 0: {
                    return this.network.getNetworkNodes()[nodeIndex].getName();
                }
            }
        } else {
            int nodeIndex = this.mapRowToNode.get(row);
            int connectionIndex = this.mapRowToConnection.get(row);
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    int sourceIndex = this.network.getNetworkNodes()[nodeIndex].getConnections()[connectionIndex].getSource();
                    return this.network.getNetworkNodes()[sourceIndex].getName();
                }
                case 2: {
                    return this.network.getNetworkNodes()[nodeIndex].getHillKs()[connectionIndex];
                }
                case 3: {
                    return this.network.getNetworkNodes()[nodeIndex].getHillNs()[connectionIndex];
                }
                case 4: {
                    return this.network.getNetworkNodes()[nodeIndex].getSQUADWeights()[connectionIndex];
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.mapRowToConnection.containsKey(row)) {
            int nodeIndex = this.mapRowToNode.get(row);
            int connectionIndex = this.mapRowToConnection.get(row);
            switch (col) {
                case 2: {
                    this.network.getNetworkNodes()[nodeIndex].getHillKs()[connectionIndex] = (Double)value;
                    this.network.notifyObserversOfChangedValues();
                    return;
                }
                case 3: {
                    this.network.getNetworkNodes()[nodeIndex].getHillNs()[connectionIndex] = (Double)value;
                    this.network.notifyObserversOfChangedValues();
                    return;
                }
                case 4: {
                    this.network.getNetworkNodes()[nodeIndex].getSQUADWeights()[connectionIndex] = (Double)value;
                    this.network.notifyObserversOfChangedValues();
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Cell not editable.");
    }

    @Override
    public void notifyNetworkChanged() {
        this.mapRowToNode = new TreeMap();
        this.mapRowToConnection = new TreeMap();
        int rowIndex = 0;
        int nodeIndex = 0;
        NetworkNode[] networkNodeArray = this.network.getNetworkNodes();
        int n = networkNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            this.mapRowToNode.put(rowIndex, nodeIndex);
            ++rowIndex;
            int connectionIndex = 0;
            Connection[] connectionArray = node.getConnections();
            int n3 = connectionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Connection connection = connectionArray[n4];
                this.mapRowToNode.put(rowIndex, nodeIndex);
                this.mapRowToConnection.put(rowIndex, connectionIndex);
                ++rowIndex;
                ++connectionIndex;
                ++n4;
            }
            ++nodeIndex;
            ++n2;
        }
        this.fireTableStructureChanged();
        this.notifyValuesChanged();
    }

    @Override
    public void notifyValuesChanged() {
        this.fireTableRowsUpdated(0, this.getRowCount());
    }
}

