/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.guilib.datatable;

import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.gui.guilib.datatable.NetworkTableModel;

public class TableModelNodes
extends NetworkTableModel
implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = 8901352050900459647L;

    public TableModelNodes(RegulatoryNetwork network) {
        super(network);
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.network.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.network.getNetworkNodes()[row].getName();
            }
            case 1: {
                return this.network.getNetworkNodes()[row].getValue();
            }
            case 2: {
                return this.network.getNetworkNodes()[row].getHillNormalize();
            }
            case 3: {
                return this.network.getNetworkNodes()[row].getOdefyDecay();
            }
            case 4: {
                return this.network.getNetworkNodes()[row].getSQUADDecay();
            }
            case 5: {
                return this.network.getNetworkNodes()[row].getSQUADSteepness();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        String[] columns = new String[]{"Node", "Value", "Hill normalized", "Odefy decay", "SQUAD decay", "SQUAD steepness"};
        return columns[col];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            return;
        }
        switch (col) {
            case 1: {
                this.network.getNetworkNodes()[row].setValue((Double)value);
                this.network.notifyObserversOfChangedValues();
                return;
            }
            case 2: {
                this.network.getNetworkNodes()[row].setHillNormalize((Boolean)value);
                this.network.notifyObserversOfChangedValues();
                return;
            }
            case 3: {
                this.network.getNetworkNodes()[row].setOdefyDecay((Double)value);
                this.network.notifyObserversOfChangedValues();
                return;
            }
            case 4: {
                this.network.getNetworkNodes()[row].setSQUADDecay((Double)value);
                this.network.notifyObserversOfChangedValues();
                return;
            }
            case 5: {
                this.network.getNetworkNodes()[row].setSQUADSteepness((Double)value);
                this.network.notifyObserversOfChangedValues();
                return;
            }
        }
        throw new IllegalArgumentException("Cell not editable.");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        Class[] columnClasses = new Class[]{String.class, Double.class, Boolean.class, Double.class, Double.class, Double.class};
        return columnClasses[col];
    }

    @Override
    public void notifyNetworkChanged() {
        this.fireTableStructureChanged();
        this.notifyValuesChanged();
    }

    @Override
    public void notifyValuesChanged() {
        this.fireTableRowsUpdated(0, this.getRowCount());
    }
}

