/*
 * Decompiled with CFR 0.152.
 */
package jimena.libs;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jimena.sssearcher.SSSearchResult;

public class StringLib {
    public static String arrayToTabSeparatedUnchecked(ArrayList<Object[]> list) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            Object[] data = list.get(i);
            if (data.length != 0) {
                int j = 0;
                while (j < data.length) {
                    if (j != 0) {
                        result.append("\t");
                    }
                    result.append(String.valueOf(data[j]));
                    ++j;
                }
            }
            if (i != list.size() - 1) {
                result.append("\n");
            }
            ++i;
        }
        return result.toString();
    }

    public static String arrayToCommaSeparatedUnchecked(byte[][] list) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            byte[] data = list[i];
            if (data.length != 0) {
                int j = 0;
                while (j < data.length) {
                    if (j != 0) {
                        result.append(", ");
                    }
                    result.append(String.valueOf(data[j]));
                    ++j;
                }
            }
            if (i != list.length - 1) {
                result.append("\n");
            }
            ++i;
        }
        return result.toString();
    }

    public static void writeToClipboard(String content) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferable = new StringSelection(content);
        clipboard.setContents(transferable, null);
    }

    public static String readFromClipboard() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static void printDoubleVectorList(ArrayList<double[]> list) {
        if (list == null) {
            System.out.println("null");
            return;
        }
        for (double[] vector : list) {
            System.out.println(Arrays.toString(vector));
        }
    }

    public static void printSSSearchResult(SSSearchResult results) {
        if (results == null) {
            System.out.println("null");
            return;
        }
        int i = 0;
        while (i < results.getResults().size()) {
            System.out.println(results.getCounter().get(i) + ": " + Arrays.toString(results.getResults().get(i)));
            ++i;
        }
    }

    public static void printByteVectorList(ArrayList<byte[]> list) {
        if (list == null) {
            System.out.println("null");
            return;
        }
        for (byte[] vector : list) {
            System.out.println(Arrays.toString(vector));
        }
    }

    public static boolean equalsTrimmed(String one, String two) {
        return one.trim().equals(two.trim());
    }

    public static void printDiscreteSSS(String[] nodeNames, List<byte[]> ss) {
        int padding = StringLib.maxStringLength(nodeNames);
        int i = 0;
        while (i < nodeNames.length) {
            System.out.print(StringLib.padLeft(nodeNames[i], padding));
            for (byte[] b : ss) {
                System.out.print(" " + b[i]);
            }
            System.out.println();
            ++i;
        }
    }

    public static String padRight(String string, int length) {
        return String.format("%1$-" + length + "s", string);
    }

    public static String padLeft(String string, int length) {
        return String.format("%1$" + length + "s", string);
    }

    public static int maxStringLength(String[] strings) {
        int max = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            max = Math.max(max, s.length());
            ++n2;
        }
        return max;
    }
}

