/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.SimulationMethod;

public abstract class ContinuousSimulationMethod
extends SimulationMethod {
    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        double k;
        int nodeCount = network.size();
        double[] ksum = new double[nodeCount];
        double[] results1 = new double[nodeCount];
        double[] results2 = new double[nodeCount];
        int i = 0;
        while (i < nodeCount) {
            k = dt * this.getDerivativeValue(network, i, network.getValues(results2));
            results1[i] = k / 2.0 + network.getNetworkNodes()[i].getValue();
            ksum[i] = k;
            ++i;
        }
        i = 0;
        while (i < nodeCount) {
            k = dt * this.getDerivativeValue(network, i, results1);
            results2[i] = k / 2.0 + network.getNetworkNodes()[i].getValue();
            int n = i++;
            ksum[n] = ksum[n] + 2.0 * k;
        }
        i = 0;
        while (i < nodeCount) {
            k = dt * this.getDerivativeValue(network, i, results2);
            results1[i] = k + network.getNetworkNodes()[i].getValue();
            int n = i++;
            ksum[n] = ksum[n] + 2.0 * k;
        }
        i = 0;
        while (i < nodeCount) {
            k = dt * this.getDerivativeValue(network, i, results1);
            network.getNetworkNodes()[i].setValue((ksum[i] + k) / 6.0 + network.getNetworkNodes()[i].getValue());
            ++i;
        }
    }

    public void stepValuesOnlyOld(RegulatoryNetwork network, double dt) {
        double[] k1 = new double[network.size()];
        double[] k2 = new double[network.size()];
        double[] k3 = new double[network.size()];
        double[] k4 = new double[network.size()];
        double[] results1 = new double[network.size()];
        double[] results2 = new double[network.size()];
        double[] results3 = new double[network.size()];
        int i = 0;
        while (i < network.size()) {
            k1[i] = this.getDerivativeValue(network, i, network.getValues());
            results1[i] = k1[i] * dt / 2.0 + network.getNetworkNodes()[i].getValue();
            ++i;
        }
        i = 0;
        while (i < network.size()) {
            k2[i] = this.getDerivativeValue(network, i, results1);
            results2[i] = k2[i] * dt / 2.0 + network.getNetworkNodes()[i].getValue();
            ++i;
        }
        i = 0;
        while (i < network.size()) {
            k3[i] = this.getDerivativeValue(network, i, results2);
            results3[i] = k3[i] * dt + network.getNetworkNodes()[i].getValue();
            ++i;
        }
        i = 0;
        while (i < network.size()) {
            k4[i] = this.getDerivativeValue(network, i, results3);
            network.getNetworkNodes()[i].setValue((k1[i] + 2.0 * k2[i] + 2.0 * k3[i] + k4[i]) / 6.0 * dt + network.getNetworkNodes()[i].getValue());
            ++i;
        }
    }

    public abstract double getDerivativeValue(RegulatoryNetwork var1, int var2, double[] var3);

    @Override
    public boolean isContinuous() {
        return true;
    }
}

