/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import java.util.ArrayList;
import java.util.Collections;
import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.DiscreteSimulationMethod;
import jimena.simulationmethods.SimulationMethod;

public class DARBNMethod
extends DiscreteSimulationMethod {
    private static ArrayList<Integer> order;

    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        int i;
        if (order == null || order.size() != network.size()) {
            order = new ArrayList();
            i = 0;
            while (i < network.size()) {
                order.add(i);
                ++i;
            }
            Collections.shuffle(order);
        }
        i = 0;
        while (i < order.size()) {
            NetworkNode node;
            BinaryBooleanFunction function = (node = network.getNetworkNodes()[order.get(i)]).getFunction();
            node.setValue(function.eval(this.getBooleanInputs(network, order.get(i))) ? 1.0 : 0.0);
            ++i;
        }
    }

    @Override
    public String toString() {
        return "DARBN";
    }

    @Override
    public SimulationMethod clone() {
        return new DARBNMethod();
    }
}

