/*
 * Decompiled with CFR 0.152.
 */
package jimena.sssearcher;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.gui.main.JimenaExecutor;
import jimena.simulation.ConvergenceResult;
import jimena.sssearcher.SSSearchResult;

public abstract class SSSearcher {
    public abstract SSSearchResult searchSSStates(RegulatoryNetwork var1, ConvergenceParameters var2, long var3);

    public abstract SSSearchResult searchSSStates(RegulatoryNetwork var1, long var2, ConvergenceParameters var4);

    protected static ArrayList<double[]> executeSearch(RegulatoryNetwork network, ConvergenceParameters p, ArrayList<double[]> startVectors, long maxTime) {
        ArrayList<double[]> results = new ArrayList<double[]>();
        long start = System.currentTimeMillis();
        ArrayList<double[]> realStartVectors = new ArrayList<double[]>();
        for (double[] vector : startVectors) {
            realStartVectors.add(vector);
        }
        JimenaExecutor threadPool = new JimenaExecutor(p.getThreads());
        ArrayList<Future<ConvergenceResult>> searchers = new ArrayList<Future<ConvergenceResult>>();
        int i = 0;
        while (i < realStartVectors.size()) {
            searchers.add(threadPool.submit(network.stableStateSearcher((double[])realStartVectors.get(i), p.cloneWithoutController())));
            ++i;
        }
        threadPool.shutdown();
        try {
            while (System.currentTimeMillis() - start <= maxTime && !threadPool.isTerminated()) {
                threadPool.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Interrupted.");
        }
        i = 0;
        while (i < searchers.size()) {
            try {
                if (((Future)searchers.get(i)).get() != null) {
                    results.add(((ConvergenceResult)((Future)searchers.get(i)).get()).getResult());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return results;
    }

    protected void addWithoutDuplicates(SSSearchResult searchResult, ArrayList<double[]> newItems, double duplicateMaxDiff, boolean count) {
        for (double[] newItem : newItems) {
            this.addDuplicateFree(searchResult, newItem, duplicateMaxDiff, count);
        }
    }

    protected void addDuplicateFree(SSSearchResult searchResult, double[] newItem, double duplicateMaxDiff, boolean count) {
        int j = 0;
        while (j < searchResult.getResults().size()) {
            double[] oldItem = searchResult.getResults().get(j);
            boolean isIdentical = true;
            int i = 0;
            while (i < newItem.length) {
                if (Math.abs(newItem[i] - oldItem[i]) > duplicateMaxDiff) {
                    isIdentical = false;
                    break;
                }
                ++i;
            }
            if (isIdentical) {
                if (count) {
                    searchResult.getCounter().set(j, searchResult.getCounter().get(j) + 1);
                }
                return;
            }
            ++j;
        }
        if (count) {
            searchResult.getCounter().add(1);
        } else {
            searchResult.getCounter().add(0);
        }
        searchResult.getResults().add(newItem);
    }
}

