/*
 * Decompiled with CFR 0.152.
 */
package jimena.sssearcher;

import java.util.ArrayList;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.libs.MathLib;
import jimena.sssearcher.SSSearchResult;
import jimena.sssearcher.SSSearcher;

public abstract class StepwiseSearcher
extends SSSearcher {
    private boolean initializeWithDiscreteSSS = true;

    public void setInitializeWithDiscreteSSS(boolean initializeWithDiscreteSSS) {
        this.initializeWithDiscreteSSS = initializeWithDiscreteSSS;
    }

    protected abstract ArrayList<double[]> getNextSteps(RegulatoryNetwork var1, ArrayList<double[]> var2, ArrayList<double[]> var3);

    @Override
    public SSSearchResult searchSSStates(RegulatoryNetwork network, long numberOfStarts, ConvergenceParameters parameters) {
        int stepsDone = 0;
        ArrayList<double[]> oldStarts = new ArrayList<double[]>();
        SSSearchResult foundStableStates = new SSSearchResult();
        if (this.initializeWithDiscreteSSS) {
            ArrayList<byte[]> discreteStableSteadyStates = network.discreteStableSteadyStates();
            for (byte[] bytes : discreteStableSteadyStates) {
                oldStarts.add(MathLib.transformByteArrayToDoubleArrayUnchecked(bytes));
            }
            stepsDone += oldStarts.size();
            ArrayList<double[]> initialResults = StepwiseSearcher.executeSearch(network, parameters, oldStarts, Long.MAX_VALUE);
            this.addWithoutDuplicates(foundStableStates, initialResults, parameters.getDuplicateMaxDiff(), false);
        }
        while ((long)stepsDone < numberOfStarts) {
            ArrayList<double[]> newStarts = this.getNextSteps(network, oldStarts, foundStableStates.getResults());
            this.addWithoutDuplicates(foundStableStates, StepwiseSearcher.executeSearch(network, parameters, newStarts, Long.MAX_VALUE), parameters.getDuplicateMaxDiff(), true);
            oldStarts.addAll(newStarts);
            stepsDone += newStarts.size();
            if (parameters.getCalculationController() == null) continue;
            if (!parameters.getCalculationController().isOn()) {
                return null;
            }
            parameters.getCalculationController().setProgress((double)stepsDone / (double)numberOfStarts, stepsDone);
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return foundStableStates;
    }

    @Override
    public SSSearchResult searchSSStates(RegulatoryNetwork network, ConvergenceParameters parameters, long maxTime) {
        long start = System.currentTimeMillis();
        int stepsDone = 0;
        ArrayList<double[]> oldStarts = new ArrayList<double[]>();
        SSSearchResult foundStableStates = new SSSearchResult();
        if (this.initializeWithDiscreteSSS) {
            ArrayList<byte[]> discreteStableSteadyStates = network.discreteStableSteadyStates();
            for (byte[] bytes : discreteStableSteadyStates) {
                oldStarts.add(MathLib.transformByteArrayToDoubleArrayUnchecked(bytes));
            }
            stepsDone += oldStarts.size();
            ArrayList<double[]> initialResults = StepwiseSearcher.executeSearch(network, parameters, oldStarts, maxTime + start - System.currentTimeMillis());
            this.addWithoutDuplicates(foundStableStates, initialResults, parameters.getDuplicateMaxDiff(), false);
        }
        while (System.currentTimeMillis() - start < maxTime) {
            ArrayList<double[]> newStarts = this.getNextSteps(network, oldStarts, foundStableStates.getResults());
            this.addWithoutDuplicates(foundStableStates, StepwiseSearcher.executeSearch(network, parameters, newStarts, maxTime + start - System.currentTimeMillis()), parameters.getDuplicateMaxDiff(), true);
            oldStarts.addAll(newStarts);
            stepsDone += newStarts.size();
            if (parameters.getCalculationController() == null) continue;
            if (!parameters.getCalculationController().isOn()) {
                return null;
            }
            parameters.getCalculationController().setProgress((double)(System.currentTimeMillis() - start) / (double)maxTime, stepsDone);
        }
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        return foundStableStates;
    }
}

