/*
 * Decompiled with CFR 0.152.
 */
package test.thaliana;

import java.io.File;
import java.util.ArrayList;
import jimena.binaryrn.NetworkConnection;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.libs.NetworkAnalyzer;
import jimena.libs.StringLib;
import jimena.simulationmethods.NormalizedHillCubeMethod;
import jimena.sssearcher.RandomSearcher;
import jimena.sssearcher.SSSearchResult;
import jimena.sssearcher.SSSearcher;

public class ThalianaMutationsBasins {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        try {
            network.loadYEdFile(new File("G:\\secondpaper\\realnetworks\\Thaliana\\Arabidopsis Floral Organ Fate Determination 2010 Real Boolean Functions.graphml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringLib.printDiscreteSSS(network.getNodeNames(), network.discreteStableSteadyStates());
        ThalianaMutationsBasins thalianaMutationsBasins = new ThalianaMutationsBasins();
        thalianaMutationsBasins.getClass();
        BasinAnalyzer analyzer = thalianaMutationsBasins.new BasinAnalyzer();
        ThalianaMutationsBasins.mutationAnalysis(network, 2, analyzer);
    }

    public static double basinOfInflStates(RegulatoryNetwork network) {
        int starts = 500;
        int basin = 0;
        SSSearchResult sss = network.stableSteadyStatesWithBasins(500L, new StandardConvergenceParameters(new NormalizedHillCubeMethod(), 0.05), (SSSearcher)new RandomSearcher());
        int i = 0;
        while (i < sss.getResults().size()) {
            if (sss.getResults().get(i)[3] > 0.5 && sss.getResults().get(i)[11] > 0.5) {
                basin += sss.getCounter().get(i).intValue();
            }
            ++i;
        }
        return (double)basin / 500.0;
    }

    public static void mutationAnalysis(RegulatoryNetwork original, ArrayList<NetworkConnection> usedInputs, NetworkConnection curInput, int numberOfMutations, NetworkAnalyzer analyzer) {
        if (numberOfMutations == 0) {
            return;
        }
        if (original.getNextConnection(curInput) != null) {
            ThalianaMutationsBasins.mutationAnalysis(original, usedInputs, original.getNextConnection(curInput), numberOfMutations, analyzer);
        }
        ArrayList newUsedInputs = (ArrayList)usedInputs.clone();
        newUsedInputs.add(curInput);
        original.addNullMutation(newUsedInputs);
        analyzer.run(original, original.getConnectionString(newUsedInputs));
        original.restore();
        if (original.getNextConnection(curInput) != null) {
            ThalianaMutationsBasins.mutationAnalysis(original, newUsedInputs, original.getNextConnection(curInput), numberOfMutations - 1, analyzer);
        }
    }

    public static void mutationAnalysis(RegulatoryNetwork original, int numberOfMutations, NetworkAnalyzer analyzer) {
        ThalianaMutationsBasins.mutationAnalysis(original, new ArrayList<NetworkConnection>(), original.getFirstConnection(), numberOfMutations, analyzer);
    }

    private class BasinAnalyzer
    extends NetworkAnalyzer {
        private BasinAnalyzer() {
        }

        @Override
        public void run(RegulatoryNetwork network) {
        }

        @Override
        public void run(RegulatoryNetwork network, String description) {
            System.out.print(String.valueOf(description) + ": ");
            double basin = ThalianaMutationsBasins.basinOfInflStates(network);
            System.out.println(basin);
        }
    }
}

