import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.regex.Pattern;

public class Bereinigen {

    public static void main(String[] args) {
        String input = getClipboardContents();
        String patterns[] = new String[] { "[ \\t]*\\(\\d* mal gekreuzt\\)[ \\t]*" , "[ \\t]*\\(\\d\\)[ \\t]*" , "[ \\t]*\\(von \\d+.\\d+\\% gekreuzt\\)[ \\t]*"};

        for (String pattern : patterns) {
            input = deletePattern(input, pattern);
        }

        System.out.println(input);
        setClipboardContents(input);
    }

    public static String deletePattern(String input, String pattern) {
        Pattern p = Pattern.compile(pattern);
        input = input.replaceAll(p.pattern(), "");
        return input;
    }

    /**
     * Place a String on the clipboard, and make this class the
     * owner of the Clipboard's contents.
     */
     public static void setClipboardContents(String aString){
       StringSelection stringSelection = new StringSelection(aString);
       Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
       clipboard.setContents(stringSelection, null);
     }
    
    /**
     * Get the String residing on the clipboard.
     * 
     * @return any text found on the Clipboard; if none found, return an empty String.
     */
    static public String getClipboardContents() {
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        // odd: the Object param of getContents is not currently used
        Transferable contents = clipboard.getContents(null);
        boolean hasTransferableText = (contents != null) && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String) contents.getTransferData(DataFlavor.stringFlavor);
            } catch (UnsupportedFlavorException | IOException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
        return result;
    }

}
