import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;


public class Dates {
    public static void main(String[] args) {
        Calendar calendarStart = java.util.Calendar.getInstance();
        calendarStart.set(2000,0,1);    
        
        Calendar calendarEnd = java.util.Calendar.getInstance();
        calendarEnd.set(2014,9,10);  
        
        ArrayList<Calendar> result = getDateRange(calendarStart, calendarEnd);
        
        String start = "http://www.barchart.com/historicaldata.php?file=dstk&date=";
        
        Collections.reverse(result);
        
        for(Calendar d:result){
            String out = start + String.format("%1$tm%1$td%1$ty", d);
            System.out.println(out);
        }
    }
    
    static ArrayList<Calendar> getDateRange(Calendar startDate, Calendar endDate){  
        Calendar aCalendar;  
        Date testDate;  
        ArrayList<Calendar> resultList;  
        aCalendar = (Calendar) startDate.clone();
        resultList = new ArrayList<Calendar>();  
        while(!aCalendar.after(endDate)){  
             resultList.add((Calendar) aCalendar.clone());
             aCalendar.add(java.util.Calendar.DATE, 1);
             testDate = aCalendar.getTime();
        }  
        return resultList;  
   }  
}
