import java.io.File;
import java.util.Arrays;

import jimena.binaryrn.RegulatoryNetwork;
import jimena.perturbation.OnOffPerturbation;
import jimena.simulationmethods.NormalizedHillCubeMethod;

/**
 * A collection of typical example which show how to use the simulation package as a library.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class Example2 {

    /**
     * @param args
     */
    public static void main(String[] args) {
        // Create a new GRN
        RegulatoryNetwork network = new RegulatoryNetwork();

        // Load a yED GraphML file into the network

        network.loadYEdFile(new File("I:\\secondpaper\\realnetworks\\Th\\Th 2010 Version corrected layouted.graphml"));

        // List network nodes
        System.out.println(Arrays.toString(network.getNodeNames()));
        System.out.print("\n");

        network.simulate(new NormalizedHillCubeMethod(), 0.001D, 10D, Double.POSITIVE_INFINITY, 1.0D, null);
                
        System.out.println("New value of FUL: " + network.getNodeByName("IL2R").getValue() + "\n");
        
        network.reset();
        
        network.getNodeByName("IL2").getPerturbations().add(new OnOffPerturbation(0, 100, 1));

        network.simulate(new NormalizedHillCubeMethod(), 0.001D, 10D, Double.POSITIVE_INFINITY, 1.0D, null);
                
        System.out.println("New value of FUL: " + network.getNodeByName("IL2R").getValue() + "\n");
        
        network.reset();

        network.addNullMutation(network.getConnectionsBySource(network.getNodeIndexByName("IL2")));
        
        network.simulate(new NormalizedHillCubeMethod(), 0.001D, 10D, Double.POSITIVE_INFINITY, 1.0D, null);
        
        System.out.println("New value of FUL: " + network.getNodeByName("IL2R").getValue() + "\n");

        // Stop all GUI activities.
        System.exit(0);
    }
}
