import java.io.File;

import jimena.binarybf.actinhibitf.ActivatorInhibitorFunction;
import jimena.binaryrn.NetworkConnection;
import jimena.binaryrn.RegulatoryNetwork;

public class delete {

    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File(
                "K:\\realnetworks\\Thaliana\\Arabidopsis Floral Organ Fate Determination 2010 Real Boolean Functions.graphml"));

        System.out.println("\n\n== Inhibiting ==");
        for (NetworkConnection input : network.getConnections()) {
            if (!((ActivatorInhibitorFunction) network.getNetworkNodes()[input.getNode()].getFunction()).getActivators()[input
                    .getPosition()]) {
                System.out.print(", " + "{" + network.getConnectionString(input, ", ") + "}");
            }
        }

    }

    public static double correlation(double[] p, double[] q) {
        double sumP = 0;
        double sumQ = 0;
        double sumPSquared = 0;
        double sumQSquared = 0;
        double sumPQ = 0;
        for (int i = 0; i < p.length; i++) {
            sumP += p[i];
            sumQ += q[i];
            sumPSquared += p[i] * p[i];
            sumQSquared += q[i] * q[i];
            sumPQ += p[i] * q[i];
        }

        // compute the correlation
        double r = (p.length * sumPQ - sumP * sumQ)
                / Math.sqrt((p.length * sumPSquared - sumP * sumP) * (p.length * sumQSquared - sumQ * sumQ));

        return r;
    }
}
