package jimena.gui.guilib.datatable;


import javax.swing.table.AbstractTableModel;

import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;

/**
 * Abstract table model that displays data from a binary regulatory network.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public abstract class NetworkTableModel extends AbstractTableModel implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = 6532074763279182889L;
    /**
     * The network whose data is to be displayed
     */
    protected RegulatoryNetwork network;

    /**
     * Creates a new network table model.
     * 
     * @param network
     *            The network whose data is to be displayed
     */
    public NetworkTableModel(RegulatoryNetwork network) {
        super();
        if (network == null) {
            throw new NullPointerException();
        }
        this.network = network;
        network.addObserver(this);
        notifyNetworkChanged();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            setValueAt(getValueAt(row, col), row, col);
        } catch (Exception e) {
            return false;
        }
        return true;
    }

}