package jimena.libs;

/**
 * A library for parameter checks.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class ChecksLib {
    /**
     * Throws a NullPointerException if any of the given objects is null.
     * 
     * @param objects
     *            The objects to check
     */
    public static void checkNotNull(Object... objects) {
        for (Object object : objects) {
            if (object == null) {
                throw new NullPointerException();
            }
        }
    }
}
