package jimena.libs;

import java.util.regex.Pattern;

/**
 * A library of standard precompiled patterns for regular expressions.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class PatternLib {
    private static String andPatternString = "(" + Pattern.quote("&&") + "|" + Pattern.quote("AND") + ")";
    private static String orPatternString = "(" + Pattern.quote("||") + "|" + Pattern.quote("OR") + ")";
    private static String notPatternString = "(" + Pattern.quote("!") + "|" + Pattern.quote("NOT") + ")";
    private static String numberPatternString = "\\d*";

    /**
     * A pattern for strings that contain a string representing an AND .
     */
    public static Pattern CONTAINSANDPATTERN = Pattern.compile(andPatternString, Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that contain a string representing an OR .
     */
    public static Pattern CONTAINSORPATTERN = Pattern.compile(orPatternString, Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that contain a string representing an NOT .
     */
    public static Pattern CONTAINSNOTPATTERN = Pattern.compile(notPatternString, Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that contain a string representing number .
     */
    public static Pattern CONTAINSNUMBERPATTERN = Pattern.compile(numberPatternString);

    /**
     * A pattern for strings that consist of a string representing an AND.
     */
    public static Pattern ENTIREANDPATTERN = Pattern.compile("^" + andPatternString + "$", Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that consist of a string representing an OR.
     */
    public static Pattern ENTIREORPATTERN = Pattern.compile("^" + orPatternString + "$", Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that consist of a string representing an NOT.
     */
    public static Pattern ENTIRENOTPATTERN = Pattern.compile("^" + notPatternString + "$", Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that consist of a string representing a number.
     */
    public static Pattern ENTIRENUMBERPATTERN = Pattern.compile("^" + numberPatternString + "$");

    /**
     * A pattern for strings that consist of a string representing an AND with possible leading and trailing whitespaces.
     */
    public static Pattern PADDEDENTIREANDPATTERN = Pattern.compile("^\\s*" + andPatternString + "\\s*$", Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that consist of a string representing an OR with possible leading and trailing whitespaces.
     */
    public static Pattern PADDEDENTIREORPATTERN = Pattern.compile("^\\s*" + orPatternString + "\\s*$", Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that consist of a string representing an NOT with possible leading and trailing whitespaces.
     */
    public static Pattern PADDEDENTIRENOTPATTERN = Pattern.compile("^\\s*" + notPatternString + "\\s*$", Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that consist of a string representing a number with possible leading and trailing whitespaces.
     */
    public static Pattern PADDEDENTIRENUMBERPATTERN = Pattern.compile("^\\s*" + numberPatternString + "\\s*$");

    /**
     * A pattern for strings that starts with a string representing an AND.
     */
    public static Pattern STARTSWITHANDPATTERN = Pattern.compile("^" + andPatternString, Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that starts with a string representing an OR.
     */
    public static Pattern STARTSWITHORPATTERN = Pattern.compile("^" + orPatternString, Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that starts with a string representing an NOT.
     */
    public static Pattern STARTSWITHNOTPATTERN = Pattern.compile("^" + notPatternString, Pattern.CASE_INSENSITIVE);
    /**
     * A pattern for strings that starts with a string representing a number.
     */
    public static Pattern STARTSWITHNUMBERPATTERN = Pattern.compile("^" + numberPatternString);
}
