package jimena.libs;

/**
 * Encapsulates the result of a search in a string.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class SearchResult {
    private int start;
    private int end;

    /**
     * Creates a new search result.
     * 
     * @param start
     *            First index of the match
     * @param end
     *            First index after the match
     */
    public SearchResult(int start, int end) {
        this.start = start;
        this.end = end;
    }

    /**
     * Returns the first index of the match.
     * 
     * @return First index of the match
     */
    public int getStart() {
        return start;
    }

    /**
     * Returns the first index after the match.
     * 
     * @return First index after the match
     */
    public int getEnd() {
        return end;
    }

    @Override
    public String toString() {
        return "start: " + start + ", end: " + end;
    }
}