package jimena.perturbation;

import javax.swing.JDialog;

/**
 * Implements an abstract perturbation.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public abstract class Perturbation{    
    /**
     * Returns a window to set the parameters of the perturbation.
     * 
     * @return A parameter window
     */
    public abstract JDialog getWindow();

    /**
     * Returns the value of the perturbation at a given time index.
     * 
     * @param time
     *            The time index
     * @return Value of the perturbation or a negative value if the perturbation is inactive.
     */
    public abstract double getValue(double time);
    
    /**
     * Returns a string representation of this perturbation.
     * 
     * @return String representation
     */
    public abstract String getDescription();
    
    /**
     * Returns whether the creating was aborted or not
     * 
     * @return True if the creating was aborted
     */
    public abstract boolean creationWasAborted();
    
    /**
     * Creates a deep copy of the perturbation.
     */
    @Override
    public abstract Perturbation clone();
    
    
}
