package jimena.settings;


/**
 * Encapsulates Information about settings in this settings window.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * @param <T>
 *            Type of the setting
 * 
 */
public abstract class AbstractSetting<T> extends RawSetting {
    /**
     * Minimum value of the setting.
     */
    protected T minValue;

    /**
     * Maximum value of the setting.
     */
    protected T maxValue;

    /**
     * Default value of the setting.
     */
    protected T defaultValue;

    /**
     * Creates a new Setting. Every setting will automatically be registered for the settings windows.
     * 
     * @param key
     *            Key of this setting a Preferences structure
     * @param label
     *            A short label of this setting
     * @param description
     *            The description of this setting, if null is given the label will be used
     * @param minValue
     *            The minimum value
     * @param maxValue
     *            The maximum value
     * @param defaultValue
     *            The default value
     */
    public AbstractSetting(String key, String label, String description, T minValue, T maxValue, T defaultValue) {
        super(key, label, description);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
    }

    /**
     * Returns the value of the setting.
     * 
     * If no value is stored a default value will be used.
     * 
     * @return Value of the setting
     */
    public abstract T getValue();

}
