package jimena.simulation;

/**
 * An object thats is informed of the progress of a calculation and can abort it.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public interface CalculationController {
    /**
     * Notifies the controller of the progress of the simulation.
     * 
     * @param stepsDone
     *            Completed steps
     * @param maxSteps
     *            Maximum steps
     */
    public void setProgress(int stepsDone, int maxSteps);

    /**
     * Notifies the controller of the progress of the simulation.
     * 
     * @param progress
     *            Progress of the simulation
     * @param stepsDone
     *            Steps calculated so far
     */
    public void setProgress(double progress, int stepsDone);
    
    /**
     * This method should be queried regularly during the calculation; if the result is false the calculation should be aborted as soon as
     * possible.
     * 
     * @return True, if the calculation should be aborted asap.
     */
    public boolean isOn();

    /**
     * Notifies the controller of the end of the simulation.
     * 
     */
    public void notifyCalculationFinished();
}
