package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.MathLib;

/**
 * Implements the ARBN interpolation method. One random node will be updated per step.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class ARBNMethod extends DiscreteSimulationMethod {

    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        // Choose a random node
        int i = MathLib.getRandom().nextInt(network.size());
        NetworkNode node = network.getNetworkNodes()[i];
        BinaryBooleanFunction function = node.getFunction();

        network.getNetworkNodes()[i].setValue(function.eval(getBooleanInputs(network, i)) ? 1D : 0D);
    }

    @Override
    public String toString() {
        return "ARBN";
    }

    @Override
    public SimulationMethod clone() {
        return new ARBNMethod();
    }
}
