package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;

/**
 * Implements the interpolation method used by SQUAD.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class SQUADMethod extends ContinuousSimulationMethod {

    @Override
    public double getDerivativeValue(RegulatoryNetwork network, int nodeIndex, double[] values) {
        NetworkNode node = network.getNetworkNodes()[nodeIndex];

        BinaryBooleanFunction function = node.getFunction();
        double interpol = function.interpolateSQUAD(getInputs(network, nodeIndex, values), node.getSQUADWeights());

        double h = node.getSQUADSteepness();
        double g = node.getSQUADDecay();
        double e1 = node.getExpHalfSQUADSteepness();
        double e2 = Math.exp(-h * (interpol - 0.5));
        return (-e1 + e2) / ((1 - e1) * (1 + e2)) - g * values[nodeIndex];
    }

    @Override
    public String toString() {
        return "SQUAD";
    }
    
    @Override
    public SimulationMethod clone() {
        return new SQUADMethod();
    }
}
