package jimena.sssearcher;

import java.util.ArrayList;

import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.MathLib;

/**
 * A SSS tries to find SSS by starting from random start vectors.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class RandomSearcher extends StepwiseSearcher {
    private final static int NEWSTARTSPERSTEP = 16;
    /**
     * Whether ternary values 0,0.5 and 1 are considered.
     */
    boolean ternary = false;

    @SuppressWarnings("unchecked")
    @Override
    public ArrayList<double[]> getNextSteps(RegulatoryNetwork network, ArrayList<double[]> oldStarts, ArrayList<double[]> foundStableStates) {
        ArrayList<double[]> result = new ArrayList<double[]>();

        int vectorLength = network.size();

        for (int i = 0; i < NEWSTARTSPERSTEP; i++) {
            if (ternary) {
                result.add(MathLib.randomVectorTernary(vectorLength));
            } else {
                result.add(MathLib.randomVector(vectorLength));
            }
        }

        return result;
    }

    /**
     * Creates a random seacher.
     */
    public RandomSearcher() {

    }

    /**
     * Creates a random seacher.
     * 
     * @param ternary
     *            If true, the vectors tried will consist of the values 0, 0.5 and 1 only.
     */
    public RandomSearcher(boolean ternary) {
        this.ternary = ternary;
    }
}
