/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.Point2D;
import java.io.File;
import java.util.Arrays;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.libs.StringLib;
import jimena.perturbation.OnOffPerturbation;
import jimena.simulation.BasicCalculationController;
import jimena.simulation.ProgressWindow;
import jimena.simulationmethods.NormalizedHillCubeMethod;
import jimena.sssearcher.RandomSearcher;
import jimena.sssearcher.SSSearcher;

public class Example {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("J:\\realnetworks\\Thaliana\\Arabidopsis Floral Organ Fate Determination 2010 NEW VERSION.graphml"));
        System.out.println(Arrays.toString(network.getNodeNames()));
        System.out.print("\n");
        network.getNetworkNodes()[2].setSQUADDecay(2.0);
        network.getNodeByName("AG").setSQUADDecay(2.0);
        for (Integer index : network.getConnectionPositionsByName("AG", "WUS")) {
            network.getNodeByName((String)"AG").getSQUADWeights()[index.intValue()] = 2.0;
        }
        network.getNodeByName("FUL").setValue(1.0);
        System.out.println("Old value of FUL: " + network.getNodeByName("FUL").getValue() + "\n");
        network.simulate(new NormalizedHillCubeMethod(), 1.0E-4, 10.0, Double.POSITIVE_INFINITY, 1.0, new BasicCalculationController());
        System.out.println("\nNew time index: " + network.getTimeIndex() + "\n");
        System.out.println("New value of FUL: " + network.getNodeByName("FUL").getValue() + "\n");
        for (Point2D.Double logEntry : network.getNodeByName("FUL").getLog()) {
            System.out.println(String.valueOf(logEntry.getX()) + ": " + logEntry.getY());
        }
        System.out.print("\n");
        network.reset();
        network.getNodeByName("WUS").getPerturbations().add(new OnOffPerturbation(0.0, 100.0, 1.0));
        network.simulate(new NormalizedHillCubeMethod(), 1.0E-4, 10.0, Double.POSITIVE_INFINITY, 1.0, new ProgressWindow());
        for (Point2D.Double logEntry : network.getNodeByName("WUS").getLog()) {
            System.out.println(String.valueOf(logEntry.getX()) + ": " + logEntry.getY());
        }
        System.out.print("\n");
        network.removeAllPerturbations();
        try {
            System.out.println(Arrays.toString(network.stableSteadyState(network.getValues(), new StandardConvergenceParameters(new NormalizedHillCubeMethod(), 0.01))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.print("\n");
        StringLib.printDoubleVectorList(network.stableSteadyStates(new StandardConvergenceParameters(new NormalizedHillCubeMethod(), 0.01), 1000L, (SSSearcher)new RandomSearcher()));
        System.out.print("\n");
        StringLib.printByteVectorList(network.discreteStableSteadyStates());
        System.exit(0);
    }
}

