/*
 * Decompiled with CFR 0.152.
 */
package jimena.analysis;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Future;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.gui.main.JimenaExecutor;
import jimena.libs.MathLib;
import jimena.simulation.CalculationController;
import jimena.simulation.ConvergenceResult;
import jimena.simulation.StableSteadyState;

public class ConvergenceComparator {
    private static void setCalculationController(ArrayList<Future<ConvergenceResult>> searchers1, ArrayList<Future<ConvergenceResult>> searchers2, CalculationController controller) {
        int sum = 0;
        int done = 0;
        for (Future<ConvergenceResult> run : searchers1) {
            ++sum;
            if (!run.isDone()) continue;
            ++done;
        }
        for (Future<ConvergenceResult> run : searchers2) {
            ++sum;
            if (!run.isDone()) continue;
            ++done;
        }
        if (controller != null) {
            controller.setProgress(done, sum);
        }
    }

    public static double[] differenceV(RegulatoryNetwork n1, RegulatoryNetwork n2, int simulations, ConvergenceParameters parameters) throws Exception {
        JimenaExecutor threadPool = new JimenaExecutor(parameters.getThreads());
        ArrayList<Future<ConvergenceResult>> searchers1 = new ArrayList<Future<ConvergenceResult>>();
        ArrayList<Future<ConvergenceResult>> searchers2 = new ArrayList<Future<ConvergenceResult>>();
        int i = 0;
        while (i < simulations) {
            double[] startValues = MathLib.randomVector(n1.size());
            RegulatoryNetwork networkN1 = n1.cloneClean();
            RegulatoryNetwork networkN2 = n2.cloneClean();
            networkN1.setValues(startValues);
            networkN2.setValues(startValues);
            searchers1.add(threadPool.submit(new StableSteadyState(networkN1, parameters.cloneWithoutController())));
            searchers2.add(threadPool.submit(new StableSteadyState(networkN2, parameters.cloneWithoutController())));
            ++i;
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            block9: {
                Thread.sleep(100L);
                if (parameters.getCalculationController() == null || parameters.getCalculationController().isOn()) break block9;
                return null;
            }
            try {
                ConvergenceComparator.setCalculationController(searchers1, searchers2, parameters.getCalculationController());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        double[] sumOfDifference = new double[n1.size()];
        int counted = 0;
        int i2 = 0;
        while (i2 < simulations) {
            if (searchers1.get(i2).get() != null && searchers2.get(i2).get() != null) {
                MathLib.addDoubleArraysUnchecked(sumOfDifference, MathLib.squaredDifferenceUnchecked(searchers1.get(i2).get().getResult(), searchers2.get(i2).get().getResult()));
                ++counted;
            }
            ++i2;
        }
        MathLib.scaleUnchecked(sumOfDifference, 1.0 / (double)counted);
        if (parameters.getCalculationController() != null) {
            parameters.getCalculationController().notifyCalculationFinished();
        }
        if (threadPool.getError() != null) {
            throw threadPool.getError();
        }
        return sumOfDifference;
    }

    public static double difference(RegulatoryNetwork n1, RegulatoryNetwork n2, int simulations, ConvergenceParameters parameters) throws Exception {
        return ConvergenceComparator.difference(n1, n2, n1.setOfAllNodeIndices(), simulations, parameters);
    }

    public static double difference(RegulatoryNetwork n1, RegulatoryNetwork n2, Set<Integer> nodesToConsider, int simulations, ConvergenceParameters parameters) throws Exception {
        double[] temp = ConvergenceComparator.differenceV(n1, n2, simulations, parameters);
        double result = 0.0;
        int counter = 0;
        for (Integer i : nodesToConsider) {
            result += temp[i];
            ++counter;
        }
        return result / (double)counter;
    }
}

