/*
 * Decompiled with CFR 0.152.
 */
package jimena.settings;

import java.awt.Dimension;
import java.util.prefs.Preferences;
import javax.swing.JTextField;
import jimena.gui.guilib.AutoselectingTextField;
import jimena.settings.SettingsWindow;

public abstract class RawSetting {
    protected static final Dimension textFieldDimension = new Dimension(100, 20);
    private String key;
    private String label;
    private String description;
    protected static final Preferences preferences = Preferences.userNodeForPackage(SettingsWindow.class);

    public RawSetting(String key, String label, String description) {
        if (key == null || label == null) {
            throw new NullPointerException();
        }
        if (description == null) {
            description = label;
        }
        this.key = key;
        this.label = label;
        this.description = description;
        SettingsWindow.registerSetting(this);
    }

    public abstract JTextField getTextField();

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract void reset();

    protected abstract class SettingsTextField
    extends AutoselectingTextField {
        private static final long serialVersionUID = 4945361348848721210L;

        public SettingsTextField() {
            this.setPreferredSize(textFieldDimension);
            this.setToolTipText(RawSetting.this.getDescription());
        }

        public abstract void reset();
    }
}

