/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.libs.ChecksLib;
import jimena.simulation.CalculationController;
import jimena.simulation.ConvergenceFromStartVector;
import jimena.simulation.ConvergenceResult;
import jimena.simulationmethods.SimulationMethod;

public class StableSteadyState
extends ConvergenceFromStartVector {
    private RegulatoryNetwork network;
    private SimulationMethod method;
    private double dt;
    private double maxt;
    private double stabilityMaxDiff;
    private double stabilityMinTime;
    private CalculationController calculationController = null;
    private static final long minTimeBetweenNotifications = 50L;

    public StableSteadyState(RegulatoryNetwork network, ConvergenceParameters p) {
        this(network, p.getMethod(), p.getDt(), p.getMaxT(), p.getStabilityMaxDiff(), p.getStabilityMinTime(), p.getCalculationController());
    }

    public StableSteadyState(RegulatoryNetwork network, SimulationMethod method, double dt, double maxt, double stabilityMaxDiff, double stabilityMinTime, CalculationController calculationController) {
        ChecksLib.checkNotNull(network, method);
        if (dt <= 0.0 || maxt <= 0.0 || stabilityMaxDiff <= 0.0 || stabilityMinTime <= 0.0) {
            throw new IllegalArgumentException("All numerical inputs to the constuctor of a StableSteadyState must positive.");
        }
        this.network = network;
        this.method = method;
        this.dt = dt;
        this.maxt = maxt;
        this.stabilityMaxDiff = stabilityMaxDiff;
        this.stabilityMinTime = stabilityMinTime;
        this.calculationController = calculationController;
    }

    @Override
    public ConvergenceResult call() throws Exception {
        double t = 0.0;
        if (this.network.size() == 0) {
            return null;
        }
        double lastStabilityCheckPoint = 0.0;
        int stepsDone = 0;
        long lastNotification = System.currentTimeMillis();
        double[] valuesAtLastStabilityCheckPoint = this.network.getValues();
        boolean StabilityCheckFailed = false;
        while (t <= this.maxt && (this.calculationController == null || this.calculationController.isOn())) {
            this.method.stepUpdateNetwork(this.network, this.dt);
            if (!StabilityCheckFailed) {
                int i = 0;
                while (i < this.network.size()) {
                    if (Math.abs(this.network.getNetworkNodes()[i].getValue() - valuesAtLastStabilityCheckPoint[i]) > this.stabilityMaxDiff) {
                        StabilityCheckFailed = true;
                    }
                    ++i;
                }
            }
            if (t - lastStabilityCheckPoint >= this.stabilityMinTime) {
                if (!StabilityCheckFailed) {
                    return new ConvergenceResult(this.network.getValues(), t);
                }
                valuesAtLastStabilityCheckPoint = (double[])this.network.getValues().clone();
                StabilityCheckFailed = false;
                lastStabilityCheckPoint = t;
            }
            t += this.dt;
            ++stepsDone;
            if (this.calculationController == null || System.currentTimeMillis() - lastNotification < 50L) continue;
            this.calculationController.setProgress(t / this.maxt, stepsDone);
            lastNotification = System.currentTimeMillis();
        }
        if (this.calculationController != null) {
            this.calculationController.notifyCalculationFinished();
        }
        return null;
    }
}

