/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.ObjectFactory1D;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import com.tlabs.dcolt.BlockObjectMatrix2D;
import com.tlabs.dcolt.ProxiedSparseObjectMatrix2D;
import com.tlabs.dcolt.ProxyDirectImplementation;

class BlockSparseObjectMatrix2D
extends BlockObjectMatrix2D {
    private ProxiedSparseObjectMatrix2D[][] _storage;
    private boolean diced = false;

    public BlockSparseObjectMatrix2D(int rows, int columns) {
        this(rows, columns, 250000 / columns, columns);
    }

    protected BlockSparseObjectMatrix2D(int rows, int columns, int rowsize, int colsize) {
        super(rowsize, colsize);
        this.setUp(rows, columns);
    }

    public BlockSparseObjectMatrix2D(Object[][] values) {
        this(values.length, values[0].length);
        this.assign(values);
    }

    public Object clone() {
        BlockSparseObjectMatrix2D clone = (BlockSparseObjectMatrix2D)super.clone();
        clone._storage = this._storage;
        return clone;
    }

    protected ObjectMatrix2D internalGetStorage(int sr, int sc) {
        ProxiedSparseObjectMatrix2D store;
        Object object = this.diced ? (this._storage[sc][sr] == null ? null : (ProxiedSparseObjectMatrix2D)this._storage[sc][sr].viewDice()) : (store = this._storage[sr][sc]);
        if (store == null) {
            return null;
        }
        this.setCache(store);
        return store;
    }

    protected ProxyDirectImplementation internalGetProxy(int sr, int sc) {
        return this.diced ? (this._storage[sc][sr] == null ? null : (ProxyDirectImplementation)this._storage[sc][sr].viewDice()) : this._storage[sr][sc];
    }

    protected int internalStorageColumns() {
        return this.diced ? this._storage.length : this._storage[0].length;
    }

    protected int internalStorageRows() {
        return this.diced ? this._storage[0].length : this._storage.length;
    }

    protected void internalVDiceStorage() {
        this.setCache(null);
        this.diced = !this.diced;
    }

    protected void ensureCapacity(int nbrows, int nbcols) {
        int rowsNeeded = (nbrows - 1) / this.blockRowSize + 1;
        int colsNeeded = (nbcols - 1) / this.blockColSize + 1;
        if (this._storage == null) {
            this._storage = new ProxiedSparseObjectMatrix2D[rowsNeeded][colsNeeded];
            return;
        }
        int actualRows = this._storage.length;
        int actualColumns = this._storage[0].length;
        if (rowsNeeded <= actualRows && colsNeeded <= actualColumns) {
            return;
        }
        rowsNeeded = Math.max(rowsNeeded, actualRows);
        colsNeeded = Math.max(colsNeeded, actualColumns);
        ProxiedSparseObjectMatrix2D[][] newStorage = new ProxiedSparseObjectMatrix2D[rowsNeeded][colsNeeded];
        int r = actualRows;
        for (int i = 0; i < r; ++i) {
            int c = actualColumns;
            for (int j = 0; j < c; ++j) {
                newStorage[i][j] = this._storage[i][j];
            }
        }
        this._storage = newStorage;
    }

    protected void ensureStorageBlock(int sr, int sc) {
        ProxiedSparseObjectMatrix2D proxy = null;
        proxy = (ProxiedSparseObjectMatrix2D)this.internalGetStorage(sr, sc);
        if (proxy == null) {
            proxy = new ProxiedSparseObjectMatrix2D(this.blockRowSize, this.blockColSize);
            if (this.diskMode) {
                proxy.setDiskMode(1);
            }
            if (this.diced) {
                this._storage[sc][sr] = proxy = (ProxiedSparseObjectMatrix2D)proxy.viewDice();
            } else {
                this._storage[sr][sc] = proxy;
            }
        }
        this.setCache(proxy);
    }

    public void dispose() {
        int r = this._storage.length;
        for (int i = 0; i < r; ++i) {
            int c = this._storage[0].length;
            for (int j = 0; j < c; ++j) {
                if (this._storage[i][j] == null) continue;
                this._storage[i][j].dispose();
            }
        }
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new BlockSparseObjectMatrix2D(rows, columns, this.blockRowSize, this.blockColSize);
    }

    public ObjectMatrix1D like1D(int size) {
        return ObjectFactory1D.dense.make(size);
    }
}

