/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;

class ColumnDoubleMatrix1D
extends DoubleMatrix1D {
    private final int _column;
    private DoubleMatrix2D _matrix;

    public ColumnDoubleMatrix1D(DoubleMatrix2D mat, int column) {
        this.setUp(mat.rows());
        this._column = column;
        this._matrix = mat;
    }

    public double getQuick(int index) {
        return this._matrix.getQuick(index * this.stride + this.zero, this._column);
    }

    public DoubleMatrix1D like(int size) {
        return this._matrix.like1D(size);
    }

    public DoubleMatrix2D like2D(int rows, int columns) {
        return this._matrix.like(rows, columns);
    }

    public void setQuick(int index, double value) {
        this._matrix.setQuick(index * this.stride + this.zero, this._column, value);
    }

    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new ColumnDoubleMatrix1D(this._matrix.viewSelection(offsets, null), this._column);
    }
}

