/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.ObjectFactory1D;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import com.tlabs.dcolt.ColumnObjectMatrix1D;
import com.tlabs.dcolt.DynamicObjectMatrix2D;
import com.tlabs.dcolt.DynamicStringVector;
import com.tlabs.dcolt.SelectedDecoratedObjectMatrix2D;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DecoratedObjectMatrix2D
extends DynamicObjectMatrix2D {
    private DynamicObjectMatrix2D _imp;
    private DynamicStringVector _header;
    private DynamicStringVector _ids;
    private Properties _prop;
    private Class[] _dataType;
    static /* synthetic */ Class class$java$lang$Object;

    protected DecoratedObjectMatrix2D(DynamicObjectMatrix2D inner, DynamicStringVector columnHeader, DynamicStringVector rowIds, Properties props) {
        this._imp = inner;
        this._header = columnHeader;
        this._ids = rowIds;
        this._prop = props;
        if (this._imp != null) {
            this.setUp(this._imp.rows(), this._imp.columns());
        }
    }

    protected DynamicStringVector getHeader() {
        return this._header;
    }

    protected DynamicStringVector getIds() {
        return this._ids;
    }

    protected void setIds(DynamicStringVector ids) {
        this._ids = ids;
    }

    protected void setHeader(DynamicStringVector header) {
        this._header = header;
    }

    protected void setUp(int rows, int columns) {
        this.sizeSetup(rows, columns);
        if (this._header != null && this._header.size() == 0) {
            this._header.extendTo(columns);
        }
        if (this._ids != null && this._ids.size() == 0) {
            this._ids.extendTo(rows);
        }
        this.setupInitialDataType();
    }

    private void sizeSetup(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
    }

    protected void ensureStorage(int nbrows, int nbcols) {
        this._imp.ensureStorage(nbrows, nbcols);
    }

    public void extendTo(int rows, int columns) {
        this.sizeSetup(rows, columns);
        this._imp.extendTo(rows, columns);
        this._header.extendTo(columns);
        this._ids.extendTo(rows);
        this.extendDecorations();
    }

    protected void internalSetDiskMode() {
        this._imp.setDiskMode();
    }

    protected void internalSetMemoryMode() {
        this._imp.setMemoryMode();
    }

    public void prepareBatchOperation() {
        super.prepareBatchOperation();
        this._imp.prepareBatchOperation();
        this._header.prepareBatchReading();
        this._ids.prepareBatchReading();
    }

    public void endBatchOperation() {
        this._imp.endBatchOperation();
        this._header.endBatchReading();
        this._ids.endBatchReading();
        super.endBatchOperation();
    }

    public void logBatchState() {
        this._imp.logBatchState();
    }

    public Object getQuick(int row, int column) {
        return this._imp.getQuick(row, column);
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return new DecoratedObjectMatrix2D((DynamicObjectMatrix2D)this._imp.like(rows, columns), new DynamicStringVector(), new DynamicStringVector(), new Properties());
    }

    public ObjectMatrix1D like1D(int size) {
        return ObjectFactory1D.dense.make(size);
    }

    public void setQuick(int row, int column, Object value) {
        this._imp.setQuick(row, column, value);
    }

    public void dispose() {
        this._imp.dispose();
        this._header.dispose();
        this._ids.dispose();
    }

    public ObjectMatrix2D view() {
        DecoratedObjectMatrix2D view = (DecoratedObjectMatrix2D)super.view();
        if (this._imp != null) {
            view._imp = (DynamicObjectMatrix2D)this._imp.view();
        }
        return view;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        this._imp = (DynamicObjectMatrix2D)this._imp.viewDice();
        DynamicStringVector ids = this._ids;
        this._ids = this._header;
        this._header = ids;
        return this;
    }

    public ObjectMatrix1D viewRow(int row) {
        return this._imp.viewRow(row);
    }

    public ObjectMatrix1D viewColumn(int column) {
        return new ColumnObjectMatrix1D(this, column);
    }

    public ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDecoratedObjectMatrix2D(this, rowOffsets, columnOffsets);
    }

    public int cardinality() {
        return this.isNoView ? this._imp.cardinality() : super.cardinality();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecoratedObjectMatrix2D)) {
            if (this.isNoView) {
                return this._imp.equals(obj);
            }
            return super.equals(obj);
        }
        DecoratedObjectMatrix2D o = (DecoratedObjectMatrix2D)obj;
        return this._imp.equals(o.getContent()) && this._header.equals(o.getHeader()) && this._ids.equals(o.getIds());
    }

    protected ObjectMatrix2D getContent() {
        return this._imp;
    }

    public List getColumnHeaders() {
        this._header.prepareBatchReading();
        List l = this._header.getAll();
        this._header.endBatchReading();
        return l;
    }

    public void setColumnHeaders(List headers) {
        if (headers == null) {
            this._header.clear();
        } else {
            this._header.prepareBatchReading();
            this._header.setAll(headers);
            this._header.endBatchReading();
        }
    }

    public String getColumnHeader(int col) {
        return this._header.get(col);
    }

    public void setColumnHeader(int col, String header) {
        this._header.set(col, header);
    }

    public List getRowIds() {
        this._ids.prepareBatchReading();
        List l = this._ids.getAll();
        this._ids.endBatchReading();
        return l;
    }

    public void setRowIds(List rowIds) {
        if (rowIds == null) {
            this._ids.clear();
        } else {
            this._ids.prepareBatchReading();
            this._ids.setAll(rowIds);
            this._ids.endBatchReading();
        }
    }

    public String getRowId(int row) {
        return this._ids.get(row);
    }

    public void setRowId(int row, String rowId) {
        this._ids.set(row, rowId);
    }

    public int getRowIndexFromRowId(String rowId) {
        return this._ids.indexOf(rowId);
    }

    public Properties getProperties() {
        return this._prop;
    }

    public void setProperties(Properties properties) {
        this._prop.clear();
        this._prop.putAll((Map<?, ?>)properties);
    }

    public String getProperty(String key) {
        return this._prop.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this._prop.setProperty(key, value);
    }

    public Object[] getRow(int row) {
        Object[] dataRow = new Object[this.columns()];
        int i = this.columns();
        while (--i >= 0) {
            dataRow[i] = this.getQuick(row, i);
        }
        return dataRow;
    }

    public void setRow(int row, Object[] values) {
        if (values.length != this.columns()) {
            throw new IndexOutOfBoundsException("Too many values for a row !");
        }
        for (int i = values.length - 1; i >= 0; --i) {
            this.setQuick(row, i, values[i]);
        }
    }

    public Class[] getDataType() {
        return this._dataType;
    }

    public void setDataType(Class[] dataType) {
        if (dataType.length != this.columns) {
            throw new IndexOutOfBoundsException("Not one data type for each column");
        }
        this._dataType = dataType;
    }

    public Class getDataType(int column) {
        return this._dataType[column];
    }

    public void setDataType(int column, Class dataType) {
        this._dataType[column] = dataType;
    }

    private void setupInitialDataType() {
        this._dataType = new Class[this.columns];
        Arrays.fill(this._dataType, class$java$lang$Object == null ? (class$java$lang$Object = DecoratedObjectMatrix2D.class$("java.lang.Object")) : class$java$lang$Object);
    }

    private void extendDecorations() {
        Class[] datatypes = this._dataType;
        this.setupInitialDataType();
        System.arraycopy(datatypes, 0, this._dataType, 0, Math.min(this.columns, datatypes.length));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

