/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import com.tlabs.dcolt.ColumnObjectMatrix1D;
import com.tlabs.dcolt.DynamicObjectFactory2D;
import com.tlabs.dcolt.ProxiedMatrix;
import com.tlabs.dcolt.SelectedDynamicObjectMatrix2D;
import org.apache.log4j.Logger;

public abstract class DynamicObjectMatrix2D
extends ObjectMatrix2D
implements ProxiedMatrix {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tlabs$dcolt$DynamicObjectMatrix2D == null ? (class$com$tlabs$dcolt$DynamicObjectMatrix2D = DynamicObjectMatrix2D.class$("com.tlabs.dcolt.DynamicObjectMatrix2D")) : class$com$tlabs$dcolt$DynamicObjectMatrix2D));
    protected volatile transient boolean diskMode = false;
    private volatile transient int batch;
    private transient ProxiedMatrix batchCache = null;
    private DynamicObjectMatrix2D viewRef;
    static /* synthetic */ Class class$com$tlabs$dcolt$DynamicObjectMatrix2D;

    public void setDiskMode() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " going on disk"));
        }
        this.diskMode = true;
        this.internalSetDiskMode();
    }

    public void setMemoryMode() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " going in memory"));
        }
        this.diskMode = false;
        this.batch = 0;
        if (this.batchCache != null) {
            this.batchCache.setMemoryMode();
            this.batchCache = null;
        }
        this.internalSetMemoryMode();
    }

    public boolean isDiskMode() {
        return this.diskMode;
    }

    public abstract void logBatchState();

    protected ProxiedMatrix logCacheState() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " cache: " + DynamicObjectFactory2D.identityToString(this.batchCache) + "[bacth " + this.batch + "]"));
        }
        return this.batchCache;
    }

    public abstract void extendTo(int var1, int var2);

    public void endBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " end of batch operation"));
        }
        if (this.diskMode && --this.batch == 0) {
            if (this.batchCache != null) {
                this.batchCache.endBatchOperation();
            }
            this.batchCache = null;
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " ending " + DynamicObjectFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.endBatchOperation();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    public void prepareBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " beginning of batch operation"));
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " preparing " + DynamicObjectFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.prepareBatchOperation();
        }
        if (this.diskMode) {
            ++this.batch;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    protected void setCache(ProxiedMatrix store) {
        if (this.batch > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " requested to cache " + DynamicObjectFactory2D.identityToString(store)));
            }
            if (this.batchCache != store) {
                if (this.batchCache != null) {
                    this.batchCache.endBatchOperation();
                }
                this.batchCache = store;
                if (this.batchCache != null) {
                    this.batchCache.prepareBatchOperation();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " current cache " + DynamicObjectFactory2D.identityToString(this.batchCache)));
            }
        }
    }

    protected void ensureStorage() {
        this.ensureStorage(this.rowZero + this.rows * this.rowStride, this.columnZero + this.columns * this.columnStride);
    }

    protected abstract void ensureStorage(int var1, int var2);

    protected abstract void internalSetDiskMode();

    protected abstract void internalSetMemoryMode();

    public boolean checkCoordinates(int row, int column) {
        return row >= 0 && row < this.rows && column >= 0 && column < this.columns;
    }

    public int cardinality() {
        this.prepareBatchOperation();
        int card = super.cardinality();
        this.endBatchOperation();
        return card;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectMatrix2D)) {
            return false;
        }
        ObjectMatrix2D mat = (ObjectMatrix2D)obj;
        this.prepareBatchOperation();
        if (mat instanceof ProxiedMatrix) {
            ((ProxiedMatrix)mat).prepareBatchOperation();
        }
        boolean b = super.equals(obj);
        this.endBatchOperation();
        if (mat instanceof ProxiedMatrix) {
            ((ProxiedMatrix)mat).endBatchOperation();
        }
        return b;
    }

    protected ObjectMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError("Should NEVER happen");
    }

    protected ObjectMatrix2D view() {
        DynamicObjectMatrix2D objectMatrix2D = (DynamicObjectMatrix2D)super.view();
        objectMatrix2D.viewRef = this;
        objectMatrix2D.batchCache = null;
        objectMatrix2D.batch = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " creating view " + DynamicObjectFactory2D.identityToString(objectMatrix2D)));
        }
        return objectMatrix2D;
    }

    public ObjectMatrix1D viewColumn(int column) {
        return new ColumnObjectMatrix1D(this, column);
    }

    public ObjectMatrix1D viewRow(int row) {
        return this.viewDice().viewColumn(row);
    }

    public ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDynamicObjectMatrix2D(this, rowOffsets, columnOffsets);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

