/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.function.Double9Function;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntIntDoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import com.tlabs.dcolt.DynamicDoubleFactory2D;
import com.tlabs.dcolt.ProxiedMatrix;
import com.tlabs.dcolt.ProxyDirectImplementation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

class ProxiedSparseDoubleMatrix2D
extends SparseDoubleMatrix2D
implements ProxyDirectImplementation {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tlabs$dcolt$ProxiedSparseDoubleMatrix2D == null ? (class$com$tlabs$dcolt$ProxiedSparseDoubleMatrix2D = ProxiedSparseDoubleMatrix2D.class$("com.tlabs.dcolt.ProxiedSparseDoubleMatrix2D")) : class$com$tlabs$dcolt$ProxiedSparseDoubleMatrix2D));
    private volatile transient boolean needFileUpdate;
    private volatile transient boolean diskMode;
    private volatile transient int batch;
    private transient File proxy;
    private ProxiedSparseDoubleMatrix2D viewRef;
    static /* synthetic */ Class class$com$tlabs$dcolt$ProxiedSparseDoubleMatrix2D;

    public ProxiedSparseDoubleMatrix2D(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public ProxiedSparseDoubleMatrix2D(int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        super(rows, columns, initialCapacity, minLoadFactor, maxLoadFactor);
        this.init();
    }

    public ProxiedSparseDoubleMatrix2D(double[][] values) {
        super(values);
        this.init();
    }

    private void init() {
        this.needFileUpdate = true;
        this.diskMode = false;
        this.batch = 0;
        this.proxy = null;
        this.viewRef = null;
    }

    public void setDiskMode() {
        this.setDiskMode(0);
    }

    protected void setDiskMode(int startBatch) {
        if (this.diskMode) {
            return;
        }
        this.diskMode = true;
        if (this.viewRef != null) {
            this.viewRef.setDiskMode(startBatch);
            this.needFileUpdate = this.viewRef.needFileUpdate;
            this.elements = this.viewRef.elements;
        } else if (startBatch == 0) {
            if (this.needFileUpdate) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " going on disk"));
                    }
                    this.writeElements();
                    this.needFileUpdate = false;
                    this.elements = null;
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to write content", (Throwable)e);
                }
            } else {
                this.elements = null;
            }
        }
    }

    public void setMemoryMode() {
        if (!this.diskMode) {
            return;
        }
        if (this.viewRef != null) {
            this.viewRef.setMemoryMode();
            this.needFileUpdate = this.viewRef.needFileUpdate;
            this.elements = this.viewRef.elements;
        }
        if (this.batch > 0) {
            LOG.warn((Object)(DynamicDoubleFactory2D.identityToString(this) + "switching from batch " + this.batch + " to memory"));
            this.batch = 0;
            this.diskMode = false;
        } else if (this.elements == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " going in memory"));
                }
                this.readElements();
                this.diskMode = false;
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to read matrix back", (Throwable)e);
            }
        }
    }

    public int getBatch() {
        return this.batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeElements() throws IOException {
        ObjectOutputStream out = null;
        try {
            if (this.proxy == null) {
                this.proxy = File.createTempFile("_mat_", ".tmp");
            }
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.proxy)));
            out.writeObject(this.elements);
            Object var3_2 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to close output object stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            out.close();
            return;
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to close output object stream", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readElements() throws IOException {
        ObjectInputStream in = null;
        in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.proxy)));
        this.elements = (AbstractIntDoubleMap)in.readObject();
        this.needFileUpdate = false;
        Object var4_2 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to close input data stream", (Throwable)e);
        }
        return;
        {
            catch (ClassNotFoundException e) {
                LOG.fatal((Object)"Unable to deserialize elements", (Throwable)e);
                throw new IOException("Unable to deserialize elements\n" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to close input data stream", (Throwable)e);
            }
            throw throwable;
        }
    }

    public void prepareBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " beginning of batch operation"));
        }
        if (!this.diskMode) {
            return;
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " preparing " + DynamicDoubleFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.prepareBatchOperation();
            this.elements = this.viewRef.elements;
        }
        if (this.batch++ == 0 && this.elements == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " going in memory"));
                }
                this.readElements();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to load back the matrix", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    public void endBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " end of batch operation"));
        }
        if (!this.diskMode) {
            return;
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " ending " + DynamicDoubleFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.endBatchOperation();
            this.needFileUpdate = this.viewRef.needFileUpdate;
            this.elements = this.viewRef.elements;
        }
        if (--this.batch == 0 && this.elements != null) {
            if (this.needFileUpdate) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " going on disk"));
                    }
                    this.writeElements();
                    this.needFileUpdate = false;
                    this.elements = null;
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to write the matrix", (Throwable)e);
                }
            } else {
                this.elements = null;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.batch > 0) {
            LOG.warn((Object)("Disposing " + DynamicDoubleFactory2D.identityToString(this) + " while operating batch " + this.batch));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Disposing " + DynamicDoubleFactory2D.identityToString(this)));
        }
        if (this.viewRef != null) {
            this.proxy = null;
            this.viewRef.dispose();
        } else if (this.proxy != null) {
            try {
                if (!this.proxy.delete()) {
                    LOG.error((Object)"Unable to delete element file");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to delete element file", (Throwable)e);
            }
            finally {
                this.proxy = null;
            }
        }
        this.elements = null;
    }

    public boolean isDiskMode() {
        return this.diskMode;
    }

    public void flagAsModified() {
        if (LOG.isDebugEnabled() && !this.needFileUpdate) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " flag as modified"));
        }
        this.needFileUpdate = true;
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " flagging " + DynamicDoubleFactory2D.identityToString(this.viewRef) + " as modified"));
            }
            this.viewRef.flagAsModified();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.prepareBatchOperation();
        s.defaultWriteObject();
        this.endBatchOperation();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.needFileUpdate = true;
    }

    public double aggregate(DoubleDoubleFunction aggr, DoubleFunction f) {
        this.prepareBatchOperation();
        double value = super.aggregate(aggr, f);
        this.endBatchOperation();
        return value;
    }

    public double aggregate(DoubleMatrix2D other, DoubleDoubleFunction aggr, DoubleDoubleFunction f) {
        this.prepareBatchOperation();
        if (other instanceof ProxiedMatrix) {
            ((ProxiedMatrix)other).prepareBatchOperation();
        }
        double value = super.aggregate(other, aggr, f);
        if (other instanceof ProxiedMatrix) {
            ((ProxiedMatrix)other).endBatchOperation();
        }
        this.endBatchOperation();
        return value;
    }

    public DoubleMatrix2D assign(double[][] values) {
        this.prepareBatchOperation();
        super.assign(values);
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public DoubleMatrix2D assign(double value) {
        this.prepareBatchOperation();
        super.assign(value);
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public DoubleMatrix2D assign(DoubleFunction function) {
        this.prepareBatchOperation();
        super.assign(function);
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        this.prepareBatchOperation();
        if (source instanceof ProxiedMatrix) {
            ProxiedMatrix p = (ProxiedMatrix)source;
            p.prepareBatchOperation();
            super.assign(source);
            p.endBatchOperation();
        } else {
            super.assign(source);
        }
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D y, DoubleDoubleFunction function) {
        this.prepareBatchOperation();
        if (y instanceof ProxiedMatrix) {
            ProxiedMatrix p = (ProxiedMatrix)y;
            p.prepareBatchOperation();
            super.assign(y, function);
            p.endBatchOperation();
        } else {
            super.assign(y, function);
        }
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public int cardinality() {
        this.prepareBatchOperation();
        int card = super.cardinality();
        this.endBatchOperation();
        return card;
    }

    public void ensureCapacity(int minCapacity) {
        this.prepareBatchOperation();
        super.ensureCapacity(minCapacity);
        this.flagAsModified();
        this.endBatchOperation();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        this.prepareBatchOperation();
        if (obj instanceof ProxiedMatrix) {
            ((ProxiedMatrix)obj).prepareBatchOperation();
        }
        boolean isequals = super.equals(obj);
        if (obj instanceof ProxiedMatrix) {
            ((ProxiedMatrix)obj).endBatchOperation();
        }
        this.endBatchOperation();
        return isequals;
    }

    public DoubleMatrix2D forEachNonZero(IntIntDoubleFunction function) {
        this.prepareBatchOperation();
        super.forEachNonZero(function);
        this.endBatchOperation();
        return this;
    }

    public double getQuick(int row, int column) {
        if (this.elements != null) {
            return super.getQuick(row, column);
        }
        this.prepareBatchOperation();
        double value = super.getQuick(row, column);
        this.endBatchOperation();
        return value;
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        this.prepareBatchOperation();
        super.getNonZeros(rowList, columnList, valueList);
        this.endBatchOperation();
    }

    public DoubleMatrix1D like1D(int size, int zero, int stride) {
        this.prepareBatchOperation();
        DoubleMatrix1D doubleMatrix1D = super.like1D(size, zero, stride);
        this.endBatchOperation();
        return doubleMatrix1D;
    }

    public void setQuick(int row, int column, double value) {
        if (this.elements != null) {
            super.setQuick(row, column, value);
            this.flagAsModified();
            return;
        }
        this.prepareBatchOperation();
        super.setQuick(row, column, value);
        this.flagAsModified();
        this.endBatchOperation();
    }

    public double[][] toArray() {
        this.prepareBatchOperation();
        double[][] array = super.toArray();
        this.endBatchOperation();
        return array;
    }

    public void trimToSize() {
        this.prepareBatchOperation();
        super.trimToSize();
        this.flagAsModified();
        this.endBatchOperation();
    }

    protected DoubleMatrix2D view() {
        ProxiedSparseDoubleMatrix2D doubleMatrix2D = (ProxiedSparseDoubleMatrix2D)super.view();
        doubleMatrix2D.viewRef = this;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " creating view " + DynamicDoubleFactory2D.identityToString(doubleMatrix2D)));
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        this.prepareBatchOperation();
        DoubleMatrix2D doubleMatrix2D = super.viewSelectionLike(rowOffsets, columnOffsets);
        this.endBatchOperation();
        return doubleMatrix2D;
    }

    public void zAssign8Neighbors(DoubleMatrix2D B, Double9Function function) {
        this.prepareBatchOperation();
        if (B instanceof ProxiedMatrix) {
            ProxiedMatrix p = (ProxiedMatrix)B;
            p.prepareBatchOperation();
            super.zAssign8Neighbors(B, function);
            p.endBatchOperation();
        } else {
            super.zAssign8Neighbors(B, function);
        }
        this.endBatchOperation();
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, boolean transposeA) {
        this.prepareBatchOperation();
        DoubleMatrix1D doubleMatrix1D = super.zMult(y, z, alpha, beta, transposeA);
        this.endBatchOperation();
        return doubleMatrix1D;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        this.prepareBatchOperation();
        if (B instanceof ProxiedMatrix) {
            ((ProxiedMatrix)B).prepareBatchOperation();
        }
        if (C instanceof ProxiedMatrix) {
            ((ProxiedMatrix)C).prepareBatchOperation();
        }
        C = super.zMult(B, C, alpha, beta, transposeA, transposeB);
        if (B instanceof ProxiedMatrix) {
            ((ProxiedMatrix)B).endBatchOperation();
        }
        if (C instanceof ProxiedMatrix) {
            if (C instanceof ProxyDirectImplementation) {
                ((ProxyDirectImplementation)C).flagAsModified();
            }
            ((ProxiedMatrix)C).endBatchOperation();
        }
        this.endBatchOperation();
        return C;
    }

    public double zSum() {
        this.prepareBatchOperation();
        double zsum = super.zSum();
        this.endBatchOperation();
        return zsum;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

