/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;

public class GraphicsUtils
extends SynthGraphicsUtils {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");

    public void paintText(SynthContext sc, Graphics g, String text, int x, int y, int mnemonicIndex) {
        JTabbedPane tb;
        JComponent c = sc.getComponent();
        if (sc.getRegion() == Region.BUTTON || sc.getRegion() == Region.TOGGLE_BUTTON) {
            String imagePath = (String)SyntheticaLookAndFeel.get("Synthetica.button.textBackground", c);
            if (imagePath != null && imagePath.length() > 0) {
                Insets sInsets;
                Insets dInsets = sInsets = (Insets)SyntheticaLookAndFeel.get("Synthetica.button.textBackground.insets", c);
                AbstractButton b = (AbstractButton)c;
                String label = b.getText();
                if (label != null && label.trim().length() > 0) {
                    FontMetrics fm = b.getFontMetrics(b.getFont());
                    int h = fm.getHeight();
                    int w = fm.stringWidth(label);
                    ImagePainter imagePainter = new ImagePainter(g, x - 2, y, w + 4, h, imagePath, sInsets, dInsets, 0, 0);
                    imagePainter.draw();
                }
            }
        } else if (sc.getRegion() == Region.TABBED_PANE_TAB && !(tb = (JTabbedPane)c).getTitleAt(tb.getSelectedIndex()).equals(text) && SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", tb)) {
            int wBold = g.getFontMetrics().stringWidth(text);
            g.setFont(g.getFont().deriveFont(0));
            int wPlain = g.getFontMetrics().stringWidth(text);
            x += (wBold - wPlain) / 2;
        }
        if (JAVA5 && (SyntheticaLookAndFeel.getAntiAliasEnabled() || SyntheticaLookAndFeel.getBoolean("Synthetica.text.antialias", c))) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintText(sc, g, text, x, y, mnemonicIndex);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        } else {
            super.paintText(sc, g, text, x, y, mnemonicIndex);
        }
    }

    public void drawLine(SynthContext sc, Object paintKey, Graphics g, int x1, int y1, int x2, int y2) {
        JComponent c = sc.getComponent();
        if (paintKey instanceof String && ((String)paintKey).startsWith("Tree.")) {
            String lineType;
            Color color = null;
            if (paintKey.equals("Tree.horizontalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.horizontal", c);
            } else if (paintKey.equals("Tree.verticalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.vertical", c);
            }
            if (color != null) {
                g.setColor(color);
            }
            if ("SOLID".equals(lineType = SyntheticaLookAndFeel.getString("Synthetica.tree.line.type", c))) {
                g.drawLine(x1, y1, x2, y2);
            } else if ("DASHED".equals(lineType)) {
                int dashedSpace;
                int dashedLine = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.line", c);
                if (dashedLine <= 0) {
                    dashedLine = 2;
                }
                if ((dashedSpace = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.space", c)) <= 0) {
                    dashedSpace = 1;
                }
                if (paintKey.equals("Tree.horizontalLine")) {
                    int x = x1;
                    while (x < x2) {
                        g.drawLine(x, y1, Math.min(x + dashedLine - 1, x2), y2);
                        x += dashedLine + dashedSpace;
                    }
                } else {
                    int y = y1;
                    while (y < y2) {
                        g.drawLine(x1, y, x1, Math.min(y + dashedLine - 1, y2));
                        y += dashedLine + dashedSpace;
                    }
                }
            }
            return;
        }
        super.drawLine(sc, paintKey, g, x1, y1, x2, y2);
    }

    public String layoutText(SynthContext sc, FontMetrics fm, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int iconTextGap) {
        JComponent c = sc.getComponent();
        if (c instanceof JTabbedPane) {
            hTextPosition = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.text.position.leading", c) ? 10 : 11;
            SynthStyleFactory ssf = SyntheticaLookAndFeel.getStyleFactory();
            SynthStyle ss = ssf.getStyle(sc.getComponent(), Region.TABBED_PANE);
            if (ss.get(sc, "TabbedPane.textIconGap") == null) {
                iconTextGap = 4;
            }
        }
        if (c instanceof JMenuItem && c.getParent() instanceof JPopupMenu) {
            this.menuItemTextGapCorrection(sc, (JMenuItem)c, viewR);
        }
        String s = super.layoutText(sc, fm, text, icon, hAlign, vAlign, hTextPosition, vTextPosition, viewR, iconR, textR, iconTextGap);
        if (c instanceof JMenuItem && c.getParent() instanceof JPopupMenu) {
            this.menuItemIndentCorrection(sc, (JMenuItem)c, textR, iconR);
        }
        if (c instanceof JTabbedPane) {
            this.tabbedPaneTabCorrection(sc, (JTabbedPane)c, fm, text, icon, viewR, textR, iconR);
        }
        return s;
    }

    private void menuItemTextGapCorrection(SynthContext sc, JMenuItem mi, Rectangle viewRect) {
        JPopupMenu popup = (JPopupMenu)mi.getParent();
        SynthStyleFactory ssf = SyntheticaLookAndFeel.getStyleFactory();
        SynthStyle ss = ssf.getStyle(mi, Region.MENU_ITEM);
        int gap = (Integer)ss.get(sc, "MenuItem.textIconGap");
        if (!(mi instanceof JRadioButtonMenuItem || mi instanceof JCheckBoxMenuItem || SyntheticaLookAndFeel.popupHasCheckRadio(popup))) {
            viewRect.x -= gap;
            viewRect.width += gap;
        }
        if (mi instanceof JRadioButtonMenuItem || mi instanceof JCheckBoxMenuItem || mi instanceof JMenu) {
            mi.setIconTextGap(gap);
            if (JAVA5) {
                viewRect.x += gap - 4;
                viewRect.width -= gap - 4;
                if (mi instanceof JMenu) {
                    viewRect.width += 6 - gap;
                }
                if (mi instanceof JMenu && mi.getIcon() != null) {
                    SynthStyle st = ssf.getStyle(mi, Region.MENU);
                    int mgap = (Integer)st.get(sc, "Menu.textIconGap");
                    viewRect.x += gap + 4 - mgap * 2;
                    viewRect.width += mgap * 2 - gap - 4;
                }
            }
        }
    }

    private void menuItemIndentCorrection(SynthContext sc, JMenuItem mi, Rectangle textRect, Rectangle iconRect) {
        JPopupMenu popup = (JPopupMenu)mi.getParent();
        boolean popupHasIcons = SyntheticaLookAndFeel.popupHasIcons(popup);
        boolean popupHasCheckRadio = SyntheticaLookAndFeel.popupHasCheckRadio(popup);
        int iconWidth = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.icon.width", popup, 16);
        int checkRadioIconWidth = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.checkRadioIcon.width", popup, 14);
        int iconWidthCorrection = checkRadioIconWidth < iconWidth ? iconWidth - checkRadioIconWidth : 0;
        SynthStyleFactory ssf = SyntheticaLookAndFeel.getStyleFactory();
        SynthStyle ss = ssf.getStyle(mi, Region.MENU_ITEM);
        int gap = (Integer)ss.get(sc, "MenuItem.textIconGap");
        if (JAVA5) {
            if (popupHasIcons && !popupHasCheckRadio) {
                int n = textRect.x = iconRect.width == 0 ? iconWidth : textRect.x;
            }
            if (mi instanceof JMenu) {
                SynthStyle sst = ssf.getStyle(mi, Region.MENU);
                int mgap = (Integer)sst.get(sc, "Menu.textIconGap");
                if (mi.getIcon() == null) {
                    textRect.x += gap * 2 - mgap * 2;
                    if (popupHasCheckRadio) {
                        textRect.x += checkRadioIconWidth - gap + 4;
                    }
                    if (popupHasIcons && popupHasCheckRadio) {
                        textRect.x += iconWidthCorrection;
                    } else if (!popupHasIcons && !popupHasCheckRadio) {
                        textRect.x -= gap - 4;
                    }
                } else {
                    textRect.x += gap - mgap;
                    if (popupHasCheckRadio) {
                        iconRect.x -= gap;
                        textRect.x -= gap;
                    }
                }
            } else if (popupHasIcons && popupHasCheckRadio) {
                if (mi instanceof JRadioButtonMenuItem || mi instanceof JCheckBoxMenuItem) {
                    textRect.x += gap - 4 + iconWidthCorrection;
                } else if (mi.getIcon() != null) {
                    iconRect.x += -gap;
                    textRect.x += -gap;
                } else {
                    textRect.x += checkRadioIconWidth + iconWidthCorrection;
                }
            } else if (popupHasCheckRadio) {
                textRect.x = mi instanceof JRadioButtonMenuItem || mi instanceof JCheckBoxMenuItem ? (textRect.x += gap - 4) : (textRect.x += checkRadioIconWidth);
                textRect.width += gap * 3 - 13;
            }
        } else if (popupHasIcons && popupHasCheckRadio) {
            if (mi.getIcon() != null) {
                iconRect.x -= gap;
                textRect.x -= gap;
            }
        } else if (popupHasIcons && mi instanceof JMenu && mi.getIcon() == null) {
            textRect.width += iconWidth;
        }
        if (popupHasIcons || popupHasCheckRadio) {
            int iGap = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparatorGap", popup, 0);
            textRect.x += iGap;
            textRect.width += iGap;
        }
    }

    private void tabbedPaneTabCorrection(SynthContext sc, JTabbedPane tb, FontMetrics fm, String text, Icon icon, Rectangle viewR, Rectangle textR, Rectangle iconR) {
        boolean selected = tb.getTitleAt(tb.getSelectedIndex()).equals(text);
        int placement = tb.getTabPlacement();
        int i = 0;
        while (i < tb.getTabCount()) {
            if (text.equals(tb.getTitleAt(i))) break;
            ++i;
        }
        if (tb.getIconAt(i) != null) {
            int fHeight = fm.getHeight();
            int height = Math.max(fHeight, tb.getIconAt(i).getIconHeight());
            textR.y += (fHeight - height) / 2;
        }
        String propertyKey = "tabbedPane.tab";
        if (selected) {
            propertyKey = String.valueOf(propertyKey) + ".selected";
        }
        if (placement == 1) {
            propertyKey = String.valueOf(propertyKey) + ".top";
        } else if (placement == 2) {
            propertyKey = String.valueOf(propertyKey) + ".left";
        } else if (placement == 3) {
            propertyKey = String.valueOf(propertyKey) + ".bottom";
        } else if (placement == 4) {
            propertyKey = String.valueOf(propertyKey) + ".right";
        }
        Insets insets = SyntheticaLookAndFeel.getInsets(propertyKey, "text.insets", tb.getName(), true);
        if (insets != null) {
            textR.x += insets.left;
            switch (tb.getTabPlacement()) {
                case 1: {
                    textR.y += insets.top;
                    break;
                }
                case 3: {
                    textR.y -= insets.bottom;
                }
            }
        }
        if (icon != null) {
            insets = SyntheticaLookAndFeel.getInsets(propertyKey, "icon.insets", tb.getName(), true);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            iconR.x += insets.left;
            if (tb.getTabPlacement() == 1) {
                iconR.y += insets.top;
            } else if (tb.getTabPlacement() == 3) {
                iconR.y -= insets.bottom;
            }
        }
    }
}

