/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;

class AnimationThreadFactory {
    static final int DEFAULT_TYPE = 0;
    static final int HOVER_IN_TYPE = 1;
    static final int HOVER_OUT_TYPE = 2;
    static final int FOCUSED_TYPE = 3;
    static final int DISPOSABLE_TYPE = 4;
    private static HashMap<Integer, AnimationThread> threads = new HashMap();
    private static AnimationThreadFactory instance = new AnimationThreadFactory();

    private AnimationThreadFactory() {
    }

    public static AnimationThread createThread(int delay) {
        if (threads.containsKey(delay)) {
            return threads.get(delay);
        }
        return instance.newThread(delay);
    }

    private AnimationThread newThread(int delay) {
        AnimationThread t = new AnimationThread(delay);
        threads.put(delay, t);
        t.setDaemon(true);
        t.start();
        return t;
    }

    static class AnimationThread
    extends Thread {
        private int delay = 0;
        private HashMap<ComponentKey, ComponentAnimation> componentAnimations = new HashMap();
        private ReferenceQueue<JComponent> queue = new ReferenceQueue();

        public AnimationThread(int delay) {
            this.delay = delay;
            this.setPriority(7);
            this.setName("SyntheticaAnimation " + delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    AnimationThread.sleep(this.delay);
                    HashMap<ComponentKey, ComponentAnimation> map = null;
                    HashMap<ComponentKey, ComponentAnimation> hashMap = this.componentAnimations;
                    synchronized (hashMap) {
                        Reference<JComponent> r = this.queue.poll();
                        while (r != null) {
                            this.componentAnimations.remove(((WeakComponent)r).key);
                            r = this.queue.poll();
                        }
                        map = new HashMap<ComponentKey, ComponentAnimation>(this.componentAnimations);
                    }
                    block13: for (Map.Entry<ComponentKey, ComponentAnimation> entry : map.entrySet()) {
                        JComponent c = (JComponent)entry.getKey().wc.get();
                        if (c == null) continue;
                        ComponentAnimation ca = entry.getValue();
                        if (c == null || ca == null) continue;
                        boolean hover = (ca.state & 2) > 0;
                        boolean focused = c.hasFocus();
                        Rectangle rect = ca.repaintRect;
                        switch (ca.type) {
                            case 4: {
                                if (!ca.next()) continue block13;
                                this.repaint(c, rect);
                                break;
                            }
                            case 1: {
                                if (ca.state != -1 && hover && ca.next()) {
                                    this.repaint(c, rect);
                                    break;
                                }
                                if (ca.state == -1 || hover) continue block13;
                                ca.reset();
                                break;
                            }
                            case 2: {
                                if (ca.state != -1 && !hover && ca.next()) {
                                    this.repaint(c, rect);
                                    break;
                                }
                                if (ca.state == -1 || !hover) continue block13;
                                ca.reset();
                                break;
                            }
                            case 3: {
                                Component cc;
                                if (c instanceof JComboBox && ((JComboBox)c).isEditable() && ((JComboBox)c).getEditor() != null) {
                                    cc = ((JComboBox)c).getEditor().getEditorComponent();
                                    if (cc != null) {
                                        focused = cc.hasFocus();
                                    }
                                } else if (c instanceof JSpinner) {
                                    cc = SyntheticaLookAndFeel.findComponent("Spinner.formattedTextField", c);
                                    if (cc != null) {
                                        focused = cc.hasFocus();
                                    }
                                } else if (c instanceof JScrollPane) {
                                    JScrollPane sp = (JScrollPane)c;
                                    if (sp.getViewport().getView() != null) {
                                        focused = sp.getViewport().getView().hasFocus();
                                    }
                                    int maxAnimationWidth = SyntheticaLookAndFeel.getInt("Synthetica.focus.scrollPane.animation.maxWidth", sp, 400);
                                    int maxAnimationHeight = SyntheticaLookAndFeel.getInt("Synthetica.focus.scrollPane.animation.maxHeight", sp, 200);
                                    if (sp.getWidth() > maxAnimationWidth || sp.getHeight() > maxAnimationHeight) continue block13;
                                }
                                if (!ca.next() || !focused || !this.isActive(c)) continue block13;
                                this.repaint(c, rect);
                                break;
                            }
                            default: {
                                if (!ca.next() || !this.isActive(c)) continue block13;
                                this.repaint(c, rect);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }

        private void repaint(JComponent c, Rectangle rect) {
            if (rect == null) {
                c.repaint();
            } else {
                c.repaint(rect);
            }
        }

        private boolean isActive(JComponent c) {
            Container con = c.getTopLevelAncestor();
            if (con instanceof Window) {
                return ((Window)con).isActive();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(JComponent c, String id, int state, int type, String[] imagePaths, int cycles, Rectangle repaintRect) {
            boolean hover = (state & 2) > 0;
            ComponentKey ck = new ComponentKey(c, id);
            if (this.componentAnimations.containsKey(ck)) {
                ComponentAnimation ca = this.componentAnimations.get(ck);
                ca.repaintRect = repaintRect;
                if (ca.type != type || !Arrays.toString(imagePaths).equals(Arrays.toString(ca.imagePaths))) {
                    ca.type = type;
                    ca.imagePaths = imagePaths;
                    ca.cyles = cycles;
                    ca.reset();
                }
                if (ca.state != -1 || hover) {
                    ca.state = state;
                }
                return;
            }
            ck.setComponent(c);
            ComponentAnimation ca = new ComponentAnimation();
            ca.imagePaths = imagePaths;
            ca.cyles = cycles;
            ca.repaintRect = repaintRect;
            ca.type = type;
            if (hover) {
                ca.state = state;
            }
            HashMap<ComponentKey, ComponentAnimation> hashMap = this.componentAnimations;
            synchronized (hashMap) {
                this.componentAnimations.put(ck, ca);
            }
        }

        public String getImagePath(JComponent c, String id) {
            ComponentAnimation ca = this.componentAnimations.get(new ComponentKey(c, id));
            if (ca.type == 2 && (ca.state == -1 || ca.isComplete())) {
                return ca.imagePaths[ca.imagePaths.length - 1];
            }
            return ca.imagePaths[ca.index];
        }

        private class ComponentKey {
            private int hashCode;
            private WeakComponent wc;

            ComponentKey(JComponent c, String id) {
                this.hashCode = c.hashCode() * 31 + id.hashCode();
            }

            void setComponent(JComponent c) {
                this.wc = new WeakComponent(c, this);
            }

            public boolean equals(Object obj) {
                ComponentKey ck = (ComponentKey)obj;
                return ck.hashCode == this.hashCode;
            }

            public int hashCode() {
                return this.hashCode;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WeakComponent
        extends WeakReference<JComponent> {
            private ComponentKey key;

            public WeakComponent(JComponent c, ComponentKey key) {
                super(c, AnimationThread.this.queue);
                this.key = key;
            }
        }

        private static class ComponentAnimation {
            private int state = -1;
            private int type = 0;
            private int index = 0;
            private String[] imagePaths;
            private Rectangle repaintRect;
            private long cyles = 0L;
            private long cylesDone = 0L;

            ComponentAnimation() {
            }

            boolean next() {
                if (this.cyles == 0L || this.cylesDone == this.cyles || this.imagePaths.length == 1) {
                    return false;
                }
                ++this.index;
                if (this.index == this.imagePaths.length - 1) {
                    ++this.cylesDone;
                } else if (this.index == this.imagePaths.length) {
                    this.index = 0;
                }
                return true;
            }

            void reset() {
                this.index = 0;
                this.cylesDone = 0L;
            }

            boolean isComplete() {
                return this.cyles == this.cylesDone;
            }
        }
    }
}

