/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.util.java2d.DropShadow;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class InternalFramePainter
extends SynthPainter {
    private static SynthPainter instance = new InternalFramePainter();
    private static WeakHashMap<JComponent, Object> opaqued = new WeakHashMap();

    private InternalFramePainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintInternalFrameTitlePaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        BasicInternalFrameTitlePane pane = (BasicInternalFrameTitlePane)sc.getComponent();
        Container parent = pane.getParent();
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        this.setIcons(pane, sc);
        if (!opaqued.containsKey(pane)) {
            opaqued.put(pane, null);
            Component[] components = pane.getComponents();
            int i = 0;
            while (i < components.length) {
                Component comp = components[i];
                if (comp instanceof JButton) {
                    JButton b = (JButton)comp;
                    b.setOpaque(false);
                }
                ++i;
            }
        }
        String title = "";
        if (parent instanceof JInternalFrame) {
            title = ((JInternalFrame)parent).getTitle();
        } else {
            JInternalFrame.JDesktopIcon di = (JInternalFrame.JDesktopIcon)parent;
            if (di.getInternalFrame().getTitle() != null && di.getInternalFrame().getTitle().length() > 3) {
                title = String.valueOf(di.getInternalFrame().getTitle().substring(0, 3)) + "...";
            }
        }
        String imagePath = "Synthetica.internalFrameTitlePane.background";
        if (selected) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, pane);
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.internalFrameTitlePane.background.insets", pane);
        int xPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.background.horizontalTiled", parent)) {
            xPolicy = 1;
        }
        int yPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.background.verticalTiled", parent)) {
            yPolicy = 1;
        }
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
        imagePainter.draw();
        imagePath = "Synthetica.internalFrameTitlePane.background.light";
        if (selected) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        if ((imagePath = SyntheticaLookAndFeel.getString(imagePath, parent)) != null) {
            imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, yPolicy);
            imagePainter.draw();
        }
        FontMetrics fm = pane.getFontMetrics(pane.getFont());
        int th = fm.getHeight();
        int tw = fm.stringWidth(title);
        int tx = pane.getInsets().left + 16 + 2;
        int ty = (pane.getSize().height - th) / 2;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.dropShadow", pane) && selected && tw > 0 && th > 0) {
            BufferedImage image = new BufferedImage(tw, th, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setFont(g.getFont());
            ((Graphics)g2).drawString(title, 0, fm.getAscent());
            g2.dispose();
            DropShadow ds = new DropShadow(image);
            ds.setDistance(SyntheticaLookAndFeel.getInt("Synthetica.internalFrame.titlePane.dropShadow.distance", pane, -5));
            if (SyntheticaLookAndFeel.getColor("Synthetica.internalFrame.titlePane.dropShadow.color", pane) != null) {
                ds.setShadowColor(SyntheticaLookAndFeel.getColor("Synthetica.internalFrame.titlePane.dropShadow.color", pane));
            }
            if (SyntheticaLookAndFeel.get("Synthetica.internalFrame.titlePane.dropShadow.highQuality", pane) != null) {
                ds.setQuality(SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.dropShadow.highQuality", pane));
            }
            ds.paintShadow(g, tx, ty);
        }
        g.setColor(sc.getStyle().getColor(sc, ColorType.FOREGROUND));
        sc.getStyle().getGraphicsUtils(sc).paintText(sc, g, title, tx, ty, -1);
    }

    public void paintInternalFrameTitlePaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintInternalFrameBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JInternalFrame frame = (JInternalFrame)sc.getComponent();
        String imagePath = "Synthetica.internalFrame.border";
        if (frame.isSelected()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, frame);
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.internalFrame.border.insets", frame);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.drawBorder();
    }

    private void setIcons(BasicInternalFrameTitlePane pane, SynthContext sc) {
        String hoverButton = (String)pane.getClientProperty("Synthetica.MOUSE_OVER");
        boolean hover = hoverButton != null;
        SynthStyle style = sc.getStyle();
        SynthContext scHover = new SynthContext(pane, sc.getRegion(), style, 2);
        Container parent = pane.getParent();
        String key = "InternalFrameTitlePane.iconifyIcon";
        Icon iconifyIcon = style.getIcon(sc, key);
        if (hover && hoverButton.endsWith("iconifyButton")) {
            iconifyIcon = style.getIcon(scHover, key);
        }
        key = "InternalFrameTitlePane.maximizeIcon";
        Icon maxIcon = style.getIcon(sc, key);
        if (hover && hoverButton.endsWith("maximizeButton")) {
            maxIcon = style.getIcon(scHover, key);
        }
        key = "InternalFrameTitlePane.closeIcon";
        Icon closeIcon = style.getIcon(sc, key);
        if (hover && hoverButton.endsWith("closeButton")) {
            closeIcon = style.getIcon(scHover, key);
        }
        key = "InternalFrameTitlePane.minimizeIcon";
        Icon minIcon = style.getIcon(sc, key);
        if (parent instanceof JInternalFrame && hover && hoverButton.endsWith("maximizeButton")) {
            minIcon = style.getIcon(scHover, key);
        } else if (parent instanceof JInternalFrame.JDesktopIcon && hover && hoverButton.endsWith("iconifyButton")) {
            minIcon = style.getIcon(scHover, key);
        }
        AbstractButton iconButton = null;
        AbstractButton maxButton = null;
        AbstractButton closeButton = null;
        Component[] components = pane.getComponents();
        int i = 0;
        while (i < components.length) {
            Component c = components[i];
            if (c instanceof JButton) {
                String name = c.getName();
                if (name.endsWith("closeButton")) {
                    closeButton = (JButton)c;
                }
                if (name.endsWith("iconifyButton")) {
                    iconButton = (JButton)c;
                }
                if (name.endsWith("maximizeButton")) {
                    maxButton = (JButton)c;
                }
            }
            ++i;
        }
        if (parent instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)parent;
            if (frame.isMaximum()) {
                if (iconButton != null) {
                    iconButton.setIcon(iconifyIcon);
                }
                if (maxButton != null) {
                    maxButton.setIcon(minIcon);
                }
            } else if (frame.isIcon()) {
                if (iconButton != null) {
                    iconButton.setIcon(minIcon);
                }
                if (maxButton != null) {
                    maxButton.setIcon(maxIcon);
                }
            } else {
                if (iconButton != null) {
                    iconButton.setIcon(iconifyIcon);
                }
                if (maxButton != null) {
                    maxButton.setIcon(maxIcon);
                }
            }
        } else if (parent instanceof JInternalFrame.JDesktopIcon) {
            if (iconButton != null) {
                iconButton.setIcon(minIcon);
            }
            if (maxButton != null) {
                maxButton.setIcon(maxIcon);
            }
        }
        if (closeButton != null) {
            closeButton.setIcon(closeIcon);
        }
    }
}

