/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class MenuPainter
extends SynthPainter {
    private static SynthPainter instance = new MenuPainter();

    private MenuPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void reinitialize() {
    }

    public void paintPopupMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JPopupMenu popup = (JPopupMenu)sc.getComponent();
        if (popup.getName() != null && popup.getName().startsWith("ComboPopup")) {
            return;
        }
        JPanel panel = (JPanel)popup.getParent();
        String imagePath = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.background", popup);
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.background.insets", popup);
        BufferedImage background = (BufferedImage)panel.getClientProperty("POPUP_BACKGROUND");
        if (background != null) {
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", popup)) {
                if (!((Boolean)panel.getClientProperty("POPUP_LIGHTWEIGHT")).booleanValue()) {
                    ImagePainter ip = new ImagePainter(background, g, x, y, w, h, sInsets, dInsets);
                    ip.drawBorder();
                }
                Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenu.blur.insets", popup);
                int size = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.blur.size", popup, 5);
                BufferedImage bg = Synthetica2DUtils.createBluredImage(background, size);
                ImagePainter ip = new ImagePainter(bg, g, x, y, w, h, insets, insets);
                ip.drawCenter();
                String path = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.blur.background", popup);
                if (path != null) {
                    imagePath = path;
                }
            } else {
                g.drawImage(background, x, y, null);
            }
        }
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
        imagePath = SyntheticaLookAndFeel.getString("Synthetica.popupMenu.iconSeparator", popup);
        if (imagePath != null && (SyntheticaLookAndFeel.popupHasIcons(popup) || SyntheticaLookAndFeel.popupHasCheckRadio(popup)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(popup)) {
            dInsets = sInsets = new Insets(0, 0, 0, 0);
            int separatorWidth = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", popup, 1);
            imagePainter = new ImagePainter(g, x += SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", popup, 24), y += popup.getInsets().top, separatorWidth, h -= popup.getInsets().top + popup.getInsets().bottom, imagePath, sInsets, dInsets, 0, 1);
            imagePainter.draw();
        }
    }

    public void paintMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean mouseOver;
        String imagePath = null;
        JMenu m = (JMenu)sc.getComponent();
        int state = sc.getComponentState();
        boolean disabled = (state & 8) > 0;
        boolean selected = (state & 0x200) > 0;
        Boolean b = (Boolean)m.getClientProperty("Synthetica.MOUSE_OVER");
        boolean bl = mouseOver = b == null ? false : b;
        if (mouseOver) {
            state |= 2;
        }
        boolean hover = (state & 2) > 0;
        try {
            Icon arrow = sc.getStyle().getIcon(sc, "Menu.arrowIcon");
            BasicMenuUI ui = (BasicMenuUI)((JMenu)sc.getComponent()).getUI();
            Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicMenuItemUI");
            Field field = clazz.getDeclaredField("arrowIcon");
            field.setAccessible(true);
            field.set(ui, arrow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        imagePath = "Synthetica.menu";
        Insets sInsets = null;
        if (m.isTopLevelMenu()) {
            imagePath = String.valueOf(imagePath) + ".toplevel.background";
            if (disabled) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            } else if (selected || hover) {
                imagePath = String.valueOf(imagePath) + ".selected";
            }
            imagePath = SyntheticaLookAndFeel.getString(imagePath, m);
            sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.menu.toplevel.background.insets", m);
        } else {
            if (disabled) {
                imagePath = String.valueOf(imagePath) + ".disabled";
            } else if (hover) {
                imagePath = String.valueOf(imagePath) + ".hover";
            } else if (selected) {
                imagePath = SyntheticaLookAndFeel.getString(String.valueOf(imagePath) + ".selected", m) == null ? String.valueOf(imagePath) + ".hover" : String.valueOf(imagePath) + ".selected";
            }
            imagePath = SyntheticaLookAndFeel.getString(imagePath, m);
            sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.menu.insets", m);
        }
        if (imagePath != null) {
            Insets dInsets = sInsets;
            int cycles = 0;
            int delay = 0;
            int type = 0;
            if (hover) {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.cycles", m, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.delay", m, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menu.hover.animation.type", m, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.cycles", m, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.delay", m, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menu.animation.type", m, 2);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)m, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean hover;
        JComponent c = sc.getComponent();
        String imagePath = "Synthetica.menuItem";
        int state = sc.getComponentState();
        boolean disabled = (state & 8) > 0;
        boolean bl = hover = (state & 2) > 0;
        if (disabled) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        } else if (hover) {
            imagePath = String.valueOf(imagePath) + ".hover";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, c);
        if (imagePath != null) {
            Insets sInsets;
            Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.menuItem.insets", c);
            int cycles = 0;
            int delay = 0;
            int type = 0;
            if (hover) {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.cycles", c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.delay", c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.hover.animation.type", c, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.cycles", c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.delay", c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.menuItem.animation.type", c, 2);
            }
            ImagePainter imagePainter = new ImagePainter(c, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintRadioButtonMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuItemBackground(sc, g, x, y, w, h);
    }

    public void paintCheckBoxMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        this.paintMenuItemBackground(sc, g, x, y, w, h);
    }

    public void paintMenuBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JMenuBar mb = (JMenuBar)sc.getComponent();
        String imagePath = "Synthetica.menuBar.background";
        Container parent = mb.getRootPane().getParent();
        boolean active = true;
        if (parent instanceof Window) {
            active = ((Window)parent).isActive();
        } else if (parent instanceof JInternalFrame) {
            active = ((JInternalFrame)parent).isSelected();
        }
        imagePath = active ? String.valueOf(imagePath) + ".active" : String.valueOf(imagePath) + ".inactive";
        imagePath = SyntheticaLookAndFeel.getString(imagePath, mb);
        if (imagePath != null) {
            Insets sInsets;
            Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.menuBar.background.insets", mb);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            Insets dInsets = sInsets = insets;
            int xPolicy = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuBar.background.horizontalTiled", mb)) {
                xPolicy = 1;
            }
            int yPolicy = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.menuBar.background.verticalTiled", mb)) {
                yPolicy = 1;
            }
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
            imagePainter.draw();
            imagePath = "Synthetica.menuBar.background.light";
            imagePath = active ? String.valueOf(imagePath) + ".active" : String.valueOf(imagePath) + ".inactive";
            imagePath = SyntheticaLookAndFeel.getString(imagePath, mb);
            if (imagePath != null) {
                imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, yPolicy);
                imagePainter.draw();
            }
        }
    }
}

