/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ProgressBarPainter
extends SynthPainter {
    private static SynthPainter instance = new ProgressBarPainter();
    static /* synthetic */ Class class$0;

    private ProgressBarPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintProgressBarForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int direction) {
        int minHeight;
        int minWidth;
        JComponent c = sc.getComponent();
        int state = sc.getComponentState();
        String imagePath = "Synthetica.progressBar";
        imagePath = direction == 0 ? String.valueOf(imagePath) + ".x" : String.valueOf(imagePath) + ".y";
        Insets sInsets = SyntheticaLookAndFeel.getInsets(String.valueOf(imagePath) + ".insets", c);
        if (sInsets == null) {
            sInsets = new Insets(0, 0, 0, 0);
        }
        Insets dInsets = sInsets;
        if ((sc.getComponentState() & 8) > 0) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, c);
        if (direction == 0 ? w < (minWidth = sInsets.left + sInsets.right) : h < (minHeight = sInsets.top + sInsets.bottom)) {
            return;
        }
        int width = w;
        int height = h;
        int fillPolicy = 0;
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.continuous", c)) {
            Image image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(imagePath)).getImage();
            int centerWidth = image.getWidth(null) - sInsets.left - sInsets.right;
            int centerHeight = image.getHeight(null) - sInsets.top - sInsets.bottom;
            width = (w - sInsets.left - sInsets.right) / centerWidth * centerWidth + sInsets.left + sInsets.right;
            height = (h - sInsets.top - sInsets.bottom) / centerHeight * centerHeight + sInsets.top + sInsets.bottom;
            fillPolicy = 1;
        }
        int cycles = 0;
        int delay = 0;
        int type = 0;
        if (direction == 0) {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.progressBar.x.animation.cycles", c, -1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.progressBar.x.animation.delay", c, 70);
            type = SyntheticaLookAndFeel.getInt("Synthetica.progressBar.x.animation.type", c, 0);
        } else {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.progressBar.y.animation.cycles", c, -1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.progressBar.y.animation.delay", c, 70);
            type = SyntheticaLookAndFeel.getInt("Synthetica.progressBar.y.animation.type", c, 0);
        }
        ImagePainter imagePainter = null;
        if (direction == 0) {
            imagePainter = new ImagePainter(c, cycles, delay, type, state, g, x, y, width, h, imagePath, sInsets, dInsets, fillPolicy, 0);
            imagePainter.draw();
        } else {
            imagePainter = new ImagePainter(c, cycles, delay, type, state, g, x, y - height + h, w, height, imagePath, sInsets, dInsets, 0, fillPolicy);
            imagePainter.draw();
        }
    }

    public void paintProgressBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        String imagePath = "Synthetica.progressBar";
        JProgressBar pb = (JProgressBar)sc.getComponent();
        int direction = pb.getOrientation();
        imagePath = direction == 0 ? String.valueOf(imagePath) + ".x" : String.valueOf(imagePath) + ".y";
        imagePath = String.valueOf(imagePath) + ".background";
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets(String.valueOf(imagePath) + ".insets", pb);
        if ((sc.getComponentState() & 8) > 0) {
            imagePath = String.valueOf(imagePath) + ".disabled";
        }
        if ((imagePath = SyntheticaLookAndFeel.getString(imagePath, pb)) != null) {
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }
}

