/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class ScrollBarPainter
extends SynthPainter {
    private static SynthPainter instance = new ScrollBarPainter();
    static /* synthetic */ Class class$0;

    private ScrollBarPainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintScrollBarThumbBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        Insets sInsets;
        JScrollBar scrollBar = (JScrollBar)sc.getComponent();
        int state = sc.getComponentState();
        boolean hover = (state & 2) > 0;
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.scrollBarThumb.background.insets", scrollBar);
        String gripPath = null;
        String imagePath = "Synthetica.scrollBarThumb";
        if (orientation == 0) {
            gripPath = String.valueOf(imagePath) + ".x.grip";
            imagePath = String.valueOf(imagePath) + ".x.background";
        } else {
            gripPath = String.valueOf(imagePath) + ".y.grip";
            imagePath = String.valueOf(imagePath) + ".y.background";
        }
        if (hover) {
            imagePath = String.valueOf(imagePath) + ".hover";
        }
        imagePath = SyntheticaLookAndFeel.getString(imagePath, scrollBar);
        int cycles = 0;
        int delay = 0;
        int type = 0;
        if (hover) {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.cycles", scrollBar, 1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.delay", scrollBar, 50);
            type = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.type", scrollBar, 1);
        } else {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.cycles", scrollBar, 1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.delay", scrollBar, 50);
            type = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.type", scrollBar, 2);
        }
        ImagePainter imagePainter = new ImagePainter((JComponent)scrollBar, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
        gripPath = SyntheticaLookAndFeel.getString(gripPath, scrollBar);
        if (gripPath == null) {
            return;
        }
        Image image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(gripPath)).getImage();
        int gripWidth = image.getWidth(null);
        int gripHeight = image.getHeight(null);
        int xPos = x + (w - gripWidth) / 2;
        int yPos = y + (h - gripHeight) / 2;
        if (orientation == 0 && w - 4 <= gripWidth) {
            return;
        }
        if (orientation == 1 && h - 4 <= gripHeight) {
            return;
        }
        g.drawImage(image, xPos, yPos, null);
    }

    public void paintScrollBarTrackBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JScrollBar scrollBar = (JScrollBar)sc.getComponent();
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.scrollBarTrack.background.insets", scrollBar);
        String imagePath = "Synthetica.scrollBarTrack";
        imagePath = scrollBar.getOrientation() == 0 ? String.valueOf(imagePath) + ".x.background" : String.valueOf(imagePath) + ".y.background";
        imagePath = SyntheticaLookAndFeel.getString(imagePath, scrollBar);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }
}

