/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.text.JTextComponent;

public class ScrollPanePainter
extends SynthPainter {
    private static SynthPainter instance = new ScrollPanePainter();

    private ScrollPanePainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void paintScrollPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        if (scrollPane.getViewport() == null || scrollPane.getViewport().getView() == null) {
            return;
        }
        Component component = scrollPane.getViewport().getView();
        if (SyntheticaLookAndFeel.isOpaque(scrollPane) && component instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)component;
            Color background = tc.getBackground();
            String imagePath = "Synthetica.textField.border.locked";
            if (tc instanceof JTextArea) {
                imagePath = "Synthetica.textArea.border.locked";
            } else if (tc instanceof JEditorPane) {
                imagePath = "Synthetica.editorPane.border.locked";
            }
            if (tc.isEnabled() && !tc.isEditable() && SyntheticaLookAndFeel.get(imagePath, tc) != null && (background == null || background instanceof ColorUIResource)) {
                Insets sInsets;
                tc.setOpaque(false);
                scrollPane.getViewport().setOpaque(false);
                imagePath = SyntheticaLookAndFeel.getString(imagePath, tc);
                Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.comboBox.border.insets", tc);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.draw();
                FocusPainter.installFocusListener(tc);
                if (tc.hasFocus()) {
                    FocusPainter.paintFocus("focus.scrollPane", sc, g, x, y, w, h);
                }
                return;
            }
            String key = null;
            if (tc instanceof JTextArea) {
                key = "Synthetica.textArea.border";
            } else if (tc instanceof JTextPane) {
                key = "Synthetica.textPane.border";
            } else if (tc instanceof JEditorPane) {
                key = "Synthetica.editorPane.border";
            }
            if (!tc.isEnabled()) {
                key = String.valueOf(key) + ".disabled";
            }
            if (SyntheticaLookAndFeel.getBoolean(key = String.valueOf(key) + ".opaqueBackground", tc)) {
                Insets sInsets;
                tc.setOpaque(false);
                scrollPane.getViewport().setOpaque(false);
                imagePath = "Synthetica.scrollPane.border";
                if (!scrollPane.isEnabled()) {
                    imagePath = String.valueOf(imagePath) + ".disabled";
                }
                imagePath = SyntheticaLookAndFeel.getString(imagePath, scrollPane);
                Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.insets", scrollPane);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.drawCenter();
                return;
            }
            if (!(!(background instanceof ColorUIResource) || tc.isEditable() && tc.isEnabled())) {
                if (!tc.isEditable()) {
                    if (tc instanceof JTextArea) {
                        background = SyntheticaLookAndFeel.getColor("Synthetica.textArea.lockedColor", tc);
                    } else if (tc instanceof JTextPane) {
                        background = SyntheticaLookAndFeel.getColor("Synthetica.textPane.lockedColor", tc);
                    } else if (tc instanceof JEditorPane) {
                        background = SyntheticaLookAndFeel.getColor("Synthetica.editorPane.lockedColor", tc);
                    }
                } else if (!tc.isEnabled()) {
                    if (tc instanceof JTextArea) {
                        background = SyntheticaLookAndFeel.getColor("Synthetica.textArea.disabledColor", tc);
                    } else if (tc instanceof JTextPane) {
                        background = SyntheticaLookAndFeel.getColor("Synthetica.textPane.disabledColor", tc);
                    } else if (tc instanceof JEditorPane) {
                        background = SyntheticaLookAndFeel.getColor("Synthetica.editorPane.disabledColor", tc);
                    }
                }
            }
            int arcWidth = SyntheticaLookAndFeel.get("Synthetica.scrollPane.border.arcWidth", scrollPane) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica.scrollPane.border.arcWidth", scrollPane);
            int arcHeight = SyntheticaLookAndFeel.get("Synthetica.scrollPane.border.arcHeight", scrollPane) == null ? 8 : SyntheticaLookAndFeel.getInt("Synthetica.scrollPane.border.arcHeight", scrollPane);
            Graphics2D g2 = (Graphics2D)g;
            Color color = g2.getColor();
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(background);
            g2.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
            g2.setRenderingHints(rh);
            g2.setColor(color);
        }
    }

    public void paintScrollPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        if (scrollPane.getViewport() == null || scrollPane.getViewport().getView() == null) {
            return;
        }
        Component c = scrollPane.getViewport().getView();
        Color background = c.getBackground();
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            String imagePath = "Synthetica.textField.border.locked";
            if (tc instanceof JTextArea) {
                imagePath = "Synthetica.textArea.border.locked";
            } else if (tc instanceof JEditorPane) {
                imagePath = "Synthetica.editorPane.border.locked";
            }
            if (SyntheticaLookAndFeel.isOpaque(scrollPane) && tc.isEnabled() && !tc.isEditable() && SyntheticaLookAndFeel.get(imagePath, tc) != null && (background == null || background instanceof ColorUIResource)) {
                return;
            }
        }
        String imagePath = null;
        imagePath = c.isEnabled() ? SyntheticaLookAndFeel.getString("Synthetica.scrollPane.border", scrollPane) : SyntheticaLookAndFeel.getString("Synthetica.scrollPane.border.disabled", scrollPane);
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.insets", scrollPane);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.drawBorder();
        FocusPainter.installFocusListener(c);
        if (c.hasFocus()) {
            FocusPainter.paintFocus("focus.scrollPane", sc, g, x, y, w, h);
        }
    }
}

