/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class TabbedPanePainter
extends SynthPainter {
    private static final int UNDEFINED = -1;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int LEFT_RIGHT = 2;
    private static final int TOP = 3;
    private static final int BOTTOM = 4;
    private static final int TOP_BOTTOM = 5;
    private static SynthPainter instance = new TabbedPanePainter();
    private static WeakHashMap<JTabbedPane, Object> translucentTabbedPanes = new WeakHashMap();
    static /* synthetic */ Class class$0;

    private TabbedPanePainter() {
    }

    public static SynthPainter getInstance() {
        return instance;
    }

    public void reinitialize() {
        translucentTabbedPanes = new WeakHashMap();
    }

    public void paintTabbedPaneContentBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        g.setColor(SyntheticaLookAndFeel.getColor("Synthetica.tabbedPane.hideBorderColor", tabbedPane));
        if (sc.getStyle().isOpaque(sc) && !tabbedPane.getParent().getClass().getName().equals("org.flexdock.view.Viewport") && !translucentTabbedPanes.containsKey(tabbedPane)) {
            Component[] components;
            translucentTabbedPanes.put(tabbedPane, null);
            Component[] componentArray = components = tabbedPane.getComponents();
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                Component c = componentArray[n];
                if (c instanceof Container && !(c instanceof Window) && !(c instanceof JRootPane)) {
                    this.setComponentsTranslucent(sc, (Container)c);
                }
                ++n;
            }
        }
        String imagePath = SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.contentBorder.image", tabbedPane);
        Insets sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.contentBorder.image.sourceInsets", tabbedPane);
        if (sInsets == null) {
            sInsets = new Insets(0, 0, 0, 0);
        }
        Insets dInsets = (Insets)sInsets.clone();
        int tbsw = 0;
        int tbsh = 0;
        boolean widthComplete = false;
        boolean isLeftToRight = tabbedPane.getComponentOrientation().isLeftToRight();
        int i = 0;
        while (i < tabbedPane.getTabCount()) {
            Rectangle r = tabbedPane.getBoundsAt(i);
            if (!widthComplete) {
                tbsw += r.width;
            }
            tbsh += r.height;
            if (isLeftToRight && (this.isBorderTab(tabbedPane, i) == 1 || this.isBorderTab(tabbedPane, i) == 2)) {
                widthComplete = true;
            } else if (!(isLeftToRight || this.isBorderTab(tabbedPane, i) != 0 && this.isBorderTab(tabbedPane, i) != 2)) {
                widthComplete = true;
            }
            ++i;
        }
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.drawTopLeft();
        imagePainter.drawTopCenter();
        imagePainter.drawTopRight();
        imagePainter.drawLeft();
        imagePainter.drawBottomLeft();
        imagePainter.drawBottomCenter();
        imagePainter.drawBottomRight();
        imagePainter.drawRight();
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.paintOverContentBorder.disabled", tabbedPane)) {
            this.drawContentBorderLine4SelectedTab(tabbedPane, g, x, y, w, h);
        }
    }

    private void setComponentsTranslucent(SynthContext sc, Container container) {
        Component[] components;
        StyleFactory factory = (StyleFactory)SynthLookAndFeel.getStyleFactory();
        if (container instanceof JPanel || container instanceof JScrollPane || container instanceof JViewport) {
            factory.getComponentPropertyStore().storeComponentProperty(container, "OPAQUE");
            ((JComponent)container).setOpaque(false);
        }
        Component[] componentArray = components = container.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof Container && !(c instanceof Window) && !(c instanceof JRootPane)) {
                this.setComponentsTranslucent(sc, (Container)c);
            }
            if ((c instanceof JRadioButton || c instanceof JCheckBox || c instanceof JTextArea && !(c.getParent() instanceof JViewport)) && (c.getBackground() == null || c.getBackground() instanceof ColorUIResource)) {
                factory.getComponentPropertyStore().storeComponentProperty(c, "OPAQUE");
                ((JComponent)c).setOpaque(false);
            }
            ++n;
        }
    }

    public void paintTabbedPaneTabAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneTabBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int tabIndex) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", tabbedPane) && tabbedPane.getSelectedIndex() == tabIndex && tabbedPane.hasFocus()) {
            JButton b = new JButton();
            SynthStyle ss = SynthLookAndFeel.getStyle(b, Region.BUTTON);
            sc = new SynthContext(b, Region.BUTTON, ss, 256);
            ss.getPainter(sc).paintButtonBorder(sc, g, x, y, w, h);
        }
    }

    public void paintTabbedPaneTabBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int tabIndex) {
        ImagePainter imagePainter;
        boolean mouseOver;
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        String name = tabbedPane.getName();
        int state = sc.getComponentState();
        int placement = ((JTabbedPane)sc.getComponent()).getTabPlacement();
        boolean selected = (state & 0x200) > 0;
        boolean disabled = (state & 8) > 0;
        String id = String.valueOf(placement) + "/" + tabIndex;
        Integer iHover = (Integer)tabbedPane.getClientProperty("Synthetica.MOUSE_OVER");
        int hover = iHover == null ? -1 : iHover;
        boolean bl = mouseOver = hover == tabIndex;
        if (mouseOver) {
            state |= 2;
        }
        int borderTab = this.isBorderTab(tabbedPane, tabIndex);
        String imagePath = null;
        Insets sInsets = null;
        String propertyKey = "tabbedPane.tab";
        if (mouseOver && !selected && !disabled) {
            propertyKey = String.valueOf(propertyKey) + ".hover";
        } else if (selected) {
            propertyKey = String.valueOf(propertyKey) + ".selected";
        } else if (disabled) {
            propertyKey = String.valueOf(propertyKey) + ".disabled";
        }
        if (placement == 1) {
            propertyKey = String.valueOf(propertyKey) + ".top";
        } else if (placement == 2) {
            propertyKey = String.valueOf(propertyKey) + ".left";
        } else if (placement == 3) {
            propertyKey = String.valueOf(propertyKey) + ".bottom";
        } else if (placement == 4) {
            propertyKey = String.valueOf(propertyKey) + ".right";
        }
        imagePath = SyntheticaLookAndFeel.getString(propertyKey, null, name, true);
        sInsets = SyntheticaLookAndFeel.getInsets(propertyKey, "insets", name, true);
        if (imagePath == null) {
            imagePath = selected ? (placement == 1 || placement == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.x.image.selected", tabbedPane) : SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.y.image.selected", tabbedPane)) : (disabled ? (borderTab == 0 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.left.image.disabled", tabbedPane) : (borderTab == 1 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.right.image.disabled", tabbedPane) : (borderTab == 2 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.leftRight.image.disabled", tabbedPane) : (borderTab == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.top.image.disabled", tabbedPane) : (borderTab == 4 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.bottom.image.disabled", tabbedPane) : (borderTab == 5 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.topBottom.image.disabled", tabbedPane) : (placement == 1 || placement == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.middle.image.disabled", tabbedPane) : SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.center.image.disabled", tabbedPane)))))))) : (borderTab == 0 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.left.image", tabbedPane) : (borderTab == 1 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.right.image", tabbedPane) : (borderTab == 2 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.leftRight.image", tabbedPane) : (borderTab == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.top.image", tabbedPane) : (borderTab == 4 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.bottom.image", tabbedPane) : (borderTab == 5 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.topBottom.image", tabbedPane) : (placement == 1 || placement == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.middle.image", tabbedPane) : SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.center.image", tabbedPane)))))))));
        }
        Insets bgInsets = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.noneSelected.background.insets", tabbedPane);
        if ((state & 0x200) == 0 && bgInsets != null) {
            if (placement == 1) {
                y += bgInsets.top;
            } else if (placement == 3) {
                h -= bgInsets.bottom;
            } else if (placement == 2) {
                x += bgInsets.left;
            } else if (placement == 4) {
                w -= bgInsets.right;
            }
        }
        if (placement == 3) {
            sInsets = new Insets(sInsets.bottom, sInsets.left, sInsets.top, sInsets.right);
        }
        if (placement == 4) {
            sInsets = new Insets(sInsets.top, sInsets.right, sInsets.bottom, sInsets.left);
        }
        if (sInsets == null) {
            sInsets = new Insets(0, 0, 0, 0);
        }
        Insets dInsets = (Insets)sInsets.clone();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.removeDoubleBorder", tabbedPane)) {
            if (!(placement != 1 && placement != 3 || borderTab != 0 && borderTab != -1)) {
                dInsets.right = 0;
            } else if (!(placement != 2 && placement != 4 || borderTab != 3 && borderTab != -1)) {
                dInsets.bottom = 0;
            }
        }
        if (placement == 1) {
            dInsets.bottom = 0;
        } else if (placement == 2) {
            dInsets.right = 0;
        } else if (placement == 3) {
            dInsets.top = 0;
        } else if (placement == 4) {
            dInsets.left = 0;
        }
        if (mouseOver && tabbedPane.isEnabledAt(tabIndex) && tabbedPane.getSelectedIndex() != hover && SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.red", tabbedPane, Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            int red = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.red", tabbedPane);
            int green = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.green", tabbedPane);
            int blue = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.blue", tabbedPane);
            Insets cInsets = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.hover.insets", tabbedPane);
            if (cInsets == null) {
                cInsets = new Insets(0, 0, 0, 0);
            }
            imagePainter = new ImagePainter((JComponent)tabbedPane, red, green, blue, cInsets, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        } else {
            int delay = 0;
            int cycles = 0;
            int type = 0;
            if (mouseOver) {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.tabbePane.tab.hover.animation.cycles", tabbedPane, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.tabbePane.tab.hover.animation.delay", tabbedPane, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.tabbePane.tab.hover.animation.type", tabbedPane, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.tabbePane.tab.animation.cycles", tabbedPane, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.tabbePane.tab.animation.delay", tabbedPane, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.tabbePane.tab.animation.type", tabbedPane, 2);
            }
            imagePainter = new ImagePainter(tabbedPane, id, cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        }
        if (placement != 3) {
            imagePainter.drawTopLeft();
            imagePainter.drawTopCenter();
            imagePainter.drawTopRight();
        }
        if (placement != 4) {
            imagePainter.drawLeft();
        }
        if (placement != 1) {
            imagePainter.drawBottomLeft();
            imagePainter.drawBottomCenter();
            imagePainter.drawBottomRight();
        }
        if (placement != 2) {
            imagePainter.drawRight();
        }
        imagePainter.drawCenter();
        if ((sc.getComponentState() & 0x100) > 0) {
            String key = "";
            if (placement == 1) {
                key = "focus.tabbedPane.tab.top";
            } else if (placement == 3) {
                key = "focus.tabbedPane.tab.bottom";
            } else if (placement == 2) {
                key = "focus.tabbedPane.tab.left";
            } else if (placement == 4) {
                key = "focus.tabbedPane.tab.right";
            }
            FocusPainter.paintFocus(key, sc, id, g, x, y, w, h);
        }
    }

    private int isBorderTab(JTabbedPane tabbedPane, int tabIndex) {
        if (tabIndex < 0) {
            return -1;
        }
        boolean left = false;
        boolean right = false;
        boolean top = false;
        boolean bottom = false;
        if (tabbedPane.getTabPlacement() == 1 || tabbedPane.getTabPlacement() == 3) {
            TreeMap<Rectangle, Integer> x1Tabs = new TreeMap<Rectangle, Integer>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.x > r2.x) {
                        return 1;
                    }
                    if (r1.x < r2.x) {
                        return -1;
                    }
                    return 0;
                }
            });
            TreeMap<Rectangle, Integer> x2Tabs = new TreeMap<Rectangle, Integer>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.x + r1.width < r2.x + r2.width) {
                        return 1;
                    }
                    if (r1.x + r1.width > r2.x + r2.width) {
                        return -1;
                    }
                    return 0;
                }
            });
            int i = 0;
            while (i < tabbedPane.getTabCount()) {
                x1Tabs.put(tabbedPane.getBoundsAt(i), new Integer(i));
                ++i;
            }
            if (x1Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                left = true;
            }
            i = 0;
            while (i < tabbedPane.getTabCount()) {
                x2Tabs.put(tabbedPane.getBoundsAt(i), new Integer(i));
                ++i;
            }
            if (x2Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                right = true;
            }
            if (left && right) {
                return 2;
            }
            if (left) {
                return 0;
            }
            if (right) {
                return 1;
            }
        } else {
            TreeMap<Rectangle, Integer> y1Tabs = new TreeMap<Rectangle, Integer>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.y > r2.y) {
                        return 1;
                    }
                    if (r1.y < r2.y) {
                        return -1;
                    }
                    return 0;
                }
            });
            TreeMap<Rectangle, Integer> y2Tabs = new TreeMap<Rectangle, Integer>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.y + r1.height < r2.y + r2.height) {
                        return 1;
                    }
                    if (r1.y + r1.height > r2.y + r2.height) {
                        return -1;
                    }
                    return 0;
                }
            });
            int i = 0;
            while (i < tabbedPane.getTabCount()) {
                y1Tabs.put(tabbedPane.getBoundsAt(i), new Integer(i));
                ++i;
            }
            if (y1Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                top = true;
            }
            i = 0;
            while (i < tabbedPane.getTabCount()) {
                y2Tabs.put(tabbedPane.getBoundsAt(i), new Integer(i));
                ++i;
            }
            if (y2Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                bottom = true;
            }
            if (top && bottom) {
                return 5;
            }
            if (top) {
                return 3;
            }
            if (bottom) {
                return 4;
            }
        }
        return -1;
    }

    private void drawContentBorderLine4SelectedTab(JTabbedPane tabbedPane, Graphics g, int x, int y, int w, int h) {
        int selectedTab;
        int placement = tabbedPane.getTabPlacement();
        String imagePath = placement == 1 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.top", tabbedPane) != null ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.top", tabbedPane) : (placement == 3 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.bottom", tabbedPane) != null ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.bottom", tabbedPane) : (placement == 2 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.left", tabbedPane) != null ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.left", tabbedPane) : (placement == 4 && SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.right", tabbedPane) != null ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.selected.right", tabbedPane) : (placement == 1 || placement == 3 ? SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.x.image.selected", tabbedPane) : SyntheticaLookAndFeel.getString("Synthetica.tabbedPane.tab.y.image.selected", tabbedPane)))));
        if (imagePath == null) {
            return;
        }
        Image image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(imagePath)).getImage();
        int rdb = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.removeDoubleBorder", tabbedPane)) {
            boolean rightBorderTab = false;
            int p = tabbedPane.getTabPlacement();
            int borderTab = this.isBorderTab(tabbedPane, tabbedPane.getSelectedIndex());
            if ((p == 1 || p == 3) && borderTab == 1) {
                rightBorderTab = true;
            }
            if (!rightBorderTab) {
                rdb = 1;
            }
        }
        if ((selectedTab = tabbedPane.getSelectedIndex()) == -1) {
            return;
        }
        Rectangle r = tabbedPane.getBoundsAt(selectedTab);
        String propertyKey = "tabbedPane.tab.selected";
        if (placement == 1) {
            propertyKey = String.valueOf(propertyKey) + ".top";
        } else if (placement == 2) {
            propertyKey = String.valueOf(propertyKey) + ".left";
        } else if (placement == 3) {
            propertyKey = String.valueOf(propertyKey) + ".bottom";
        } else if (placement == 4) {
            propertyKey = String.valueOf(propertyKey) + ".right";
        }
        Insets sInsets = SyntheticaLookAndFeel.getInsets(propertyKey, "insets", tabbedPane.getName(), true);
        sInsets = (Insets)sInsets.clone();
        if (placement == 3) {
            sInsets = new Insets(sInsets.bottom, sInsets.left, sInsets.top, sInsets.right);
        } else if (placement == 4) {
            sInsets = new Insets(sInsets.top, sInsets.right, sInsets.bottom, sInsets.left);
        }
        Insets dInsets = new Insets(0, 0, 0, 0);
        if (placement == 1) {
            sInsets.top = image.getHeight(null) - sInsets.bottom - 1;
            dInsets.left = sInsets.left;
            dInsets.right = sInsets.right - rdb;
            x = r.x;
            w = r.width + rdb;
            h = 1;
        } else if (placement == 3) {
            sInsets.bottom = image.getHeight(null) - sInsets.top - 1;
            dInsets.left = sInsets.left;
            dInsets.right = sInsets.right - rdb;
            x = r.x;
            y = y + h - 1;
            w = r.width + rdb;
            h = 1;
        } else if (placement == 2) {
            sInsets.left = image.getWidth(null) - sInsets.right - 1;
            dInsets.top = sInsets.top;
            dInsets.bottom = sInsets.bottom - rdb;
            x = r.x + r.width;
            y = r.y;
            w = 1;
            h = r.height + rdb;
        } else if (placement == 4) {
            sInsets.right = image.getWidth(null) - sInsets.left - 1;
            dInsets.top = sInsets.top;
            dInsets.bottom = sInsets.bottom - rdb;
            x = r.x - 1;
            y = r.y;
            w = 1;
            h = r.height + rdb;
        }
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        if (placement == 1 || placement == 3) {
            imagePainter.drawLeft();
            imagePainter.drawRight();
        } else {
            imagePainter.drawTopCenter();
            imagePainter.drawBottomCenter();
        }
        imagePainter.drawCenter();
    }
}

