/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.EventQueue;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class MenuItemStyle
extends StyleWrapper {
    private static MenuItemStyle instance = new MenuItemStyle();

    private MenuItemStyle() {
    }

    public static MenuItemStyle getStyle(SynthStyle style, JComponent c, Region region) {
        instance.setStyle(style);
        c.setOpaque(false);
        return instance;
    }

    public Font getFont(SynthContext sc) {
        MenuItemStyle.menuItemHtmlColorCorrection(sc);
        return this.synthStyle.getFont(sc);
    }

    public Icon getIcon(SynthContext sc, Object key) {
        JMenuItem mi = (JMenuItem)sc.getComponent();
        if ((mi instanceof JRadioButtonMenuItem || mi instanceof JCheckBoxMenuItem) && mi.isSelected() && !mi.isEnabled()) {
            SynthContext sc1 = new SynthContext(mi, sc.getRegion(), sc.getStyle(), 520);
            return this.synthStyle.getIcon(sc1, key);
        }
        return this.synthStyle.getIcon(sc, key);
    }

    static void menuItemHtmlColorCorrection(SynthContext sc) {
        boolean selected;
        JMenuItem item = (JMenuItem)sc.getComponent();
        String text = item.getText();
        if (text == null || item.getClientProperty("html") == null) {
            return;
        }
        SynthStyle ss = sc.getStyle();
        int state = sc.getComponentState();
        boolean hover = item instanceof JMenu ? (state & 0x200) > 0 : (state & 2) > 0;
        boolean disabled = (state & 8) > 0;
        Boolean b = (Boolean)item.getClientProperty("Synthetica.MOUSE_OVER");
        boolean menuHover = b == null ? false : b;
        boolean bl = selected = (state & 0x200) > 0;
        if (hover || disabled) {
            int index = text.toLowerCase().indexOf("<html>");
            String color = Integer.toHexString(ss.getColor(sc, ColorType.TEXT_FOREGROUND).getRGB());
            String htmlColor = "color=#" + color.substring(2);
            String html = text.substring(index, index + 6);
            text = text.replaceFirst(html, "<html><font " + htmlColor + ">");
        }
        if (!item.getParent().isVisible()) {
            item.putClientProperty("Synthetica.oldText", "");
            if (item instanceof JMenu) {
                item.putClientProperty("Synthetica.oldHover", Boolean.FALSE);
            }
        }
        String oldText = (String)item.getClientProperty("Synthetica.oldText");
        item.putClientProperty("Synthetica.oldText", text);
        boolean oldHover = false;
        if (item instanceof JMenu) {
            oldHover = (Boolean)item.getClientProperty("Synthetica.oldHover");
            item.putClientProperty("Synthetica.oldHover", menuHover);
        }
        View v = (View)item.getClientProperty("html");
        if (!oldText.equals(text) && v != item.getClientProperty("Synthetica.oldView") || item instanceof JMenu && selected && !menuHover && oldHover != menuHover) {
            item.putClientProperty("Synthetica.oldView", v);
            MenuItemStyle.updateHTMLRenderer(item);
        }
    }

    private static void updateHTMLRenderer(final JMenuItem item) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                BasicHTML.updateRenderer(item, (String)item.getClientProperty("Synthetica.oldText"));
            }
        });
    }
}

