/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ScrollPaneStyle
extends StyleWrapper {
    private static ScrollPaneStyle instance = new ScrollPaneStyle();

    private ScrollPaneStyle() {
    }

    public static ScrollPaneStyle getStyle(SynthStyle style, JComponent c, Region region) {
        instance.setStyle(style);
        return instance;
    }

    public Color getColor(SynthContext sc, ColorType type) {
        JScrollPane scrollPane = (JScrollPane)sc.getComponent();
        Component component = scrollPane.getViewport().getView();
        if (component == null) {
            return this.synthStyle.getColor(sc, type);
        }
        Color color = component.getBackground();
        if (component.getBackground() == null || component.getBackground() instanceof ColorUIResource) {
            color = Color.WHITE;
        }
        if (component instanceof JEditorPane && component.getBackground() instanceof ColorUIResource) {
            JEditorPane editorPane = (JEditorPane)component;
            if (!editorPane.isEditable()) {
                color = UIManager.getColor("Synthetica.editorPane.lockedColor");
            }
            if (!editorPane.isEnabled()) {
                color = UIManager.getColor("Synthetica.editorPane.disabledColor");
            }
        } else if (component instanceof JTextArea && component.getBackground() instanceof ColorUIResource) {
            JTextArea textArea = (JTextArea)component;
            if (!textArea.isEditable()) {
                color = UIManager.getColor("Synthetica.textArea.lockedColor");
            } else if (!textArea.isEnabled()) {
                color = UIManager.getColor("Synthetica.textArea.disabledColor");
            }
        }
        return new ColorUIResource(color);
    }
}

